/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cipher;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JHARDLib;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JCrypto {
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JHARD_LIB = "JHARD_LIB";
    private static JCrypto jCrypto = null;
    private Hashtable htable = new Hashtable();

    private JCrypto() {
    }

    public static synchronized JCrypto getInstance() {
        if (jCrypto == null) {
            jCrypto = new JCrypto();
            return jCrypto;
        }
        return jCrypto;
    }

    public boolean initialize(String deviceName, Object param) throws PKIException {
        try {
            if (this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JSOFT_LIB)) {
                String vmVender = System.getProperty("java.vm.vendor");
                String vmVersion = System.getProperty("java.vm.version");
                if (vmVender.toUpperCase().indexOf("IBM") != -1 || vmVersion.indexOf("1.5") != -1) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                } else {
                    Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                }
                this.htable.put(deviceName, new JSoftLib());
            } else if (deviceName.equals(JHARD_LIB)) {
                JHARDLib.initHardProvider();
                this.htable.put(deviceName, JHARDLib.getInstance());
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850000", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
        }
    }

    public boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (!this.htable.containsKey(deviceName)) {
                return true;
            }
            if (!deviceName.equals(JSOFT_LIB) && deviceName.equals(JHARD_LIB)) {
                JHARDLib sjyLib = JHARDLib.getInstance();
                sjyLib.finalizeHardProvider();
            }
            this.htable.remove(deviceName);
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850001", "\u5378\u8f7d\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
        }
    }

    public Session openSession(String deviceName) throws PKIException {
        Session session = (Session)this.htable.get(deviceName);
        if (session == null) {
            throw new PKIException("850002", "\u52a0\u5bc6\u4f1a\u8bdd\u672a\u8fdb\u884c\u521d\u59cb\u5316 " + deviceName);
        }
        return session;
    }
}

