/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cms.CMSEnvelopedDataParser;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.RecipientInformation;
import com.cfca.util.pki.cms.RecipientInformationStore;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.util.Collection;
import java.util.Iterator;

public class CMSEnvelopedDataParserCFCA {
    private CMSEnvelopedDataParser ep = null;

    public CMSEnvelopedDataParserCFCA(byte[] envData) throws PKIException {
        try {
            this.ep = new CMSEnvelopedDataParser(envData);
        }
        catch (IOException ex) {
            throw new PKIException("850644", "\u52a0\u8f7d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        catch (CMSException ex) {
            throw new PKIException("850644", "\u52a0\u8f7d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
    }

    public CMSEnvelopedDataParserCFCA(InputStream envelopedData) throws PKIException {
        try {
            this.ep = new CMSEnvelopedDataParser(envelopedData);
        }
        catch (IOException ex) {
            throw new PKIException("850644", "\u52a0\u8f7d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        catch (CMSException ex) {
            throw new PKIException("850644", "\u52a0\u8f7d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
    }

    public byte[] getContent(JKey reciPriKey) throws PKIException {
        RecipientInformationStore recipients = this.ep.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            Key jReciPriKey = Parser.convertKey(reciPriKey);
            try {
                int ch;
                CMSTypedStream recData = recipient.getContentStream(jReciPriKey, "BC");
                InputStream in = recData.getContentStream();
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                while ((ch = in.read()) >= 0) {
                    bOut.write(ch);
                }
                return bOut.toByteArray();
            }
            catch (NoSuchProviderException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
            catch (CMSException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
            catch (IOException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
        }
        throw new PKIException("850646", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25\uff0c\u6ca1\u6709\u5f85\u89e3\u6790\u7684\u660e\u6587");
    }

    public void getContent(JKey reciPriKey, String srcFilePath) throws PKIException {
        RecipientInformationStore recipients = this.ep.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            Key jReciPriKey = Parser.convertKey(reciPriKey);
            try {
                int ch;
                CMSTypedStream recData = recipient.getContentStream(jReciPriKey, "BC");
                InputStream in = recData.getContentStream();
                FileOutputStream fos = new FileOutputStream(srcFilePath, true);
                byte[] buff = new byte[32768];
                while ((ch = in.read(buff)) >= 0) {
                    fos.write(buff, 0, ch);
                }
                in.close();
                fos.flush();
                fos.close();
            }
            catch (NoSuchProviderException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
            catch (CMSException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
            catch (IOException ex) {
                throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", ex);
            }
        } else {
            throw new PKIException("850646", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25\uff0c\u6ca1\u6709\u5f85\u89e3\u6790\u7684\u660e\u6587");
        }
    }
}

