/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.BERConstructedOctetString;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.cms.ContentInfo;
import com.cfca.util.pki.asn1.cms.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.cms.SignedData;
import com.cfca.util.pki.asn1.cms.SignerIdentifier;
import com.cfca.util.pki.asn1.cms.SignerInfo;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.cms.CMSAttributeTableGenerator;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSProcessable;
import com.cfca.util.pki.cms.CMSSignedData;
import com.cfca.util.pki.cms.CMSSignedGenerator;
import com.cfca.util.pki.cms.CMSSignedHelper;
import com.cfca.util.pki.cms.CMSUtils;
import com.cfca.util.pki.cms.DefaultSignedAttributeTableGenerator;
import com.cfca.util.pki.cms.SignerInformation;
import com.cfca.util.pki.cms.SimpleAttributeTableGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, signedAttrGen, unsignedAttrGen, null));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(signedContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ContentInfo encInfo;
        AlgorithmIdentifier digAlgId;
        Object signer;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        this._digests.clear();
        Iterator it = this._signers.iterator();
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            try {
                digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(((SignerInformation)signer).toSignerInfo());
        }
        it = this.signerInfs.iterator();
        while (it.hasNext()) {
            signer = (SignerInf)it.next();
            try {
                digAlgId = this.makeAlgId(((SignerInf)signer).getDigestAlgOID(), ((SignerInf)signer).getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(((SignerInf)signer).toSignerInfo(contentTypeOID, content, sigProvider, addDefaultAttributes));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this._crls);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    private class SignerInf {
        PrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
        }

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSigneTable;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, String sigProvider, boolean addDefaultAttributes) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
            byte[] hash = null;
            if (content != null) {
                content.write(new DigOutputStream(dig));
                hash = dig.digest();
                CMSSignedDataGenerator.this._digests.put(this.digestOID, hash.clone());
            }
            if (addDefaultAttributes) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            ASN1Set signedAttr = CMSSignedDataGenerator.this.getAttributeSet(signed);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
            } else {
                content.write(bOut);
            }
            sig.initSign(this.key);
            sig.update(bOut.toByteArray());
            DEROctetString encDigest = new DEROctetString(sig.sign());
            Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = CMSSignedDataGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature sig) {
            this.sig = sig;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.sig.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }

        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

