/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OctetStringParser;
import com.cfca.util.pki.asn1.ASN1SequenceParser;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1SetParser;
import com.cfca.util.pki.asn1.ASN1StreamParser;
import com.cfca.util.pki.asn1.BEROctetStringGenerator;
import com.cfca.util.pki.asn1.BERSequenceGenerator;
import com.cfca.util.pki.asn1.BERSetParser;
import com.cfca.util.pki.asn1.BERTaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.cms.CMSObjectIdentifiers;
import com.cfca.util.pki.asn1.cms.ContentInfoParser;
import com.cfca.util.pki.asn1.cms.SignedDataParser;
import com.cfca.util.pki.asn1.cms.SignerInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cms.CMSContentInfoParser;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSSignedHelper;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.CMSUtils;
import com.cfca.util.pki.cms.SignerInformation;
import com.cfca.util.pki.cms.SignerInformationStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private CMSTypedStream _signedContent;
    private Map _digests;
    private CertStore _certStore;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] sigBlock) throws CMSException {
        this(new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(InputStream sigData) throws CMSException {
        this(null, sigData);
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        super(sigData);
        try {
            DEREncodable o;
            this._signedContent = signedContent;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this._digests = new HashMap();
            ASN1SetParser digAlgs = this._signedData.getDigestAlgorithms();
            while ((o = digAlgs.readObject()) != null) {
                AlgorithmIdentifier id = AlgorithmIdentifier.getInstance(o.getDERObject());
                try {
                    String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(id.getObjectId().toString());
                    MessageDigest dig = MessageDigest.getInstance(digestName);
                    this._digests.put(digestName, dig);
                }
                catch (NoSuchAlgorithmException e) {}
            }
            if (this._signedContent == null) {
                ContentInfoParser cont = this._signedData.getEncapContentInfo();
                ASN1OctetStringParser octs = (ASN1OctetStringParser)cont.getContent(4);
                if (octs != null) {
                    this._signedContent = new CMSTypedStream(cont.getContentType().getId(), octs.getOctetStream());
                }
            } else {
                ASN1OctetStringParser octs = (ASN1OctetStringParser)this._signedData.getEncapContentInfo().getContent(4);
                if (octs != null) {
                    InputStream in = octs.getOctetStream();
                    while (in.read() >= 0) {
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CMSException("io exception: " + e.getMessage(), e);
        }
        if (this._digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            HashMap hashes = new HashMap();
            Iterator it = this._digests.keySet().iterator();
            while (it.hasNext()) {
                Object digestKey = it.next();
                hashes.put(digestKey, ((MessageDigest)this._digests.get(digestKey)).digest());
            }
            try {
                DEREncodable o;
                ASN1SetParser s = this._signedData.getSignerInfos();
                while ((o = s.readObject()) != null) {
                    SignerInfo info = SignerInfo.getInstance(o.getDERObject());
                    String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(info.getDigestAlgorithm().getObjectId().getId());
                    byte[] hash = (byte[])hashes.get(digestName);
                    signerInfos.add(new SignerInformation(info, new DERObjectIdentifier(this._signedContent.getContentType()), null, hash));
                }
            }
            catch (IOException e) {
                throw new CMSException("io exception: " + e.getMessage(), e);
            }
            this._signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(type, provider, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(type, provider, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(type, provider, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this._certStore == null) {
            this.populateCertCrlSets();
            this._certStore = HELPER.createCertStore(type, provider, this._certSet, this._crlSet);
        }
        return this._certStore;
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            ASN1SetParser sCrls;
            ASN1SetParser sCerts = this._signedData.getCertificates();
            if (sCerts != null) {
                this._certSet = ASN1Set.getInstance(sCerts.getDERObject());
            }
            if ((sCrls = this._signedData.getCrls()) != null) {
                this._crlSet = ASN1Set.getInstance(sCrls.getDERObject());
            }
        }
        catch (IOException e) {
            throw new CMSException("problem parsing cert/crl sets", e);
        }
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent != null) {
            InputStream digStream = this._signedContent.getContentStream();
            Iterator it = this._digests.values().iterator();
            while (it.hasNext()) {
                digStream = new DigestInputStream(digStream, (MessageDigest)it.next());
            }
            return new CMSTypedStream(this._signedContent.getContentType(), digStream);
        }
        return null;
    }

    public static OutputStream replaceSigners(InputStream original, SignerInformationStore signerInformationStore, OutputStream out) throws CMSException, IOException {
        ASN1StreamParser in = new ASN1StreamParser(original, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        signedData.getDigestAlgorithms().getDERObject();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        Iterator it = signerInformationStore.getSigners().iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            AlgorithmIdentifier digAlgId = CMSSignedDataParser.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            digestAlgs.add(digAlgId);
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            int len;
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
            byte[] inBuffer = new byte[4096];
            byte[] outBuffer = new byte[4096];
            InputStream inOctets = octs.getOctetStream();
            OutputStream outOctets = octGen.getOctetOutputStream(outBuffer);
            while ((len = inOctets.read(inBuffer, 0, inBuffer.length)) >= 0) {
                outOctets.write(inBuffer, 0, len);
            }
            outOctets.close();
        }
        eiGen.close();
        ASN1SetParser set = signedData.getCertificates();
        if (set instanceof BERSetParser) {
            sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, set.getDERObject()).getEncoded());
        } else if (set != null) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, set.getDERObject()).getEncoded());
        }
        set = signedData.getCrls();
        if (set instanceof BERSetParser) {
            sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, set.getDERObject()).getEncoded());
        } else if (set != null) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, set.getDERObject()).getEncoded());
        }
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        Iterator it2 = signerInformationStore.getSigners().iterator();
        while (it2.hasNext()) {
            SignerInformation signer = (SignerInformation)it2.next();
            signerInfos.add(signer.toSignerInfo());
        }
        sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, CertStore certsAndCrls, OutputStream out) throws CMSException, IOException {
        ASN1Set crls;
        ASN1Set certs;
        ASN1StreamParser in = new ASN1StreamParser(original, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().getDERObject().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            int len;
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
            byte[] inBuffer = new byte[4096];
            byte[] outBuffer = new byte[4096];
            InputStream inOctets = octs.getOctetStream();
            OutputStream outOctets = octGen.getOctetOutputStream(outBuffer);
            while ((len = inOctets.read(inBuffer, 0, inBuffer.length)) >= 0) {
                outOctets.write(inBuffer, 0, len);
            }
            outOctets.close();
        }
        eiGen.close();
        ASN1SetParser set = signedData.getCertificates();
        if (set != null) {
            set.getDERObject();
        }
        if ((set = signedData.getCrls()) != null) {
            set.getDERObject();
        }
        try {
            certs = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting certs from certStore", e);
        }
        if (certs.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, certs).getEncoded());
        }
        try {
            crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting crls from certStore", e);
        }
        if (crls.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().getDERObject().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    private static DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), CMSSignedDataParser.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }
}

