/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.BEROctetStringGenerator;
import com.cfca.util.pki.asn1.BERSequenceGenerator;
import com.cfca.util.pki.asn1.BERTaggedObject;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.cms.CMSObjectIdentifiers;
import com.cfca.util.pki.asn1.cms.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.cms.SignerIdentifier;
import com.cfca.util.pki.asn1.cms.SignerInfo;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.DigestInfo;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cms.CMSAttributeTableGenerator;
import com.cfca.util.pki.cms.CMSSignedDataParser;
import com.cfca.util.pki.cms.CMSSignedGenerator;
import com.cfca.util.pki.cms.CMSSignedHelper;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.CMSUtils;
import com.cfca.util.pki.cms.SignerInformation;
import com.cfca.util.pki.cms.SignerInformationStore;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private Session session = null;
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public CMSSignedDataStreamGenerator(Session session) {
        this.session = session;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void addSigner(JKey key, X509Cert cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(digestOID);
        MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, "BC");
        this._signerInfs.add(new SignerInf(key, cert, digestOID, signedAttrGenerator, unsignedAttrGenerator, dig, this.session));
        this._messageDigests.add(dig);
    }

    public void addSigner(JKey key, X509Cert cert, String digestOID) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, null, null);
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(out, DATA, encapsulate);
    }

    public OutputStream open(OutputStream out, String signedContentType, boolean encapsulate) throws IOException {
        OutputStream digStream;
        AlgorithmIdentifier digAlgId;
        Object signer;
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(signedContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        Iterator it = this._signers.iterator();
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            digestAlgs.add(digAlgId);
        }
        it = this._signerInfs.iterator();
        while (it.hasNext()) {
            signer = (SignerInf)it.next();
            digAlgId = this.makeAlgId(((SignerInf)signer).getDigestAlgOID(), ((SignerInf)signer).getDigestAlgParams());
            digestAlgs.add(digAlgId);
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(new DERObjectIdentifier(signedContentType));
        if (encapsulate) {
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
            digStream = this._bufferSize != 0 ? octGen.getOctetOutputStream(new byte[this._bufferSize]) : octGen.getOctetOutputStream();
        } else {
            digStream = new NullOutputStream();
        }
        Iterator it2 = this._messageDigests.iterator();
        while (it2.hasNext()) {
            digStream = new DigestOutputStream(digStream, (MessageDigest)it2.next());
        }
        return new CmsSignedDataOutputStream(digStream, signedContentType, sGen, sigGen, eiGen);
    }

    private DERInteger calculateVersion(String contentOid) {
        Object obj;
        Iterator it;
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this._certs != null) {
            it = this._certs.iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new DERInteger(5);
        }
        if (this._crls != null && !otherCert) {
            it = this._crls.iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new DERInteger(5);
        }
        if (attrCertV2Found) {
            return new DERInteger(4);
        }
        if (attrCertV1Found) {
            return new DERInteger(3);
        }
        if (contentOid.equals(DATA)) {
            if (this.checkForVersion3(this._signers)) {
                return new DERInteger(3);
            }
            return new DERInteger(1);
        }
        return new DERInteger(3);
    }

    private boolean checkForVersion3(List signerInfos) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            SignerInfo s = SignerInfo.getInstance(((SignerInformation)it.next()).toSignerInfo());
            if (s.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certIt;
            X509Certificate cert;
            SignerInformation signer;
            int readLen;
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            PKCS12 p12Receive2 = new PKCS12();
            p12Receive2.load("d:/temp/userCert.pfx");
            p12Receive2.decrypt("111".toCharArray());
            JKey revPrvKey2 = p12Receive2.getPrivateKey();
            X509Cert receiveCert2 = p12Receive2.getCertificate();
            FileOutputStream fos = new FileOutputStream("D:/temp/cmsSignedDataBuf");
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
            gen.setBufferSize(32768);
            gen.addSigner(revPrvKey2, receiveCert2, PKCSObjectIdentifiers.md5.getId());
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(Parser.convertX509Cert(receiveCert2));
            CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(certs);
            OutputStream sigOut = gen.open(fos, false);
            BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, 32768);
            FileInputStream srcFIS = new FileInputStream("d:/temp/10M.doc");
            BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, 32768);
            int fileLen = srcFIS.available();
            byte[] data = new byte[32768];
            for (int readTotalLen = 0; readTotalLen < fileLen; readTotalLen += readLen) {
                readLen = srcBufIS.read(data);
                if (readLen == -1) {
                    if (fileLen == readTotalLen) break;
                    throw new Exception("\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
                }
                bfOut.write(data, 0, readLen);
            }
            bfOut.close();
            FileInputStream fis = new FileInputStream("D:/temp/cmsSignedDataBuf");
            BufferedInputStream bis = new BufferedInputStream(fis, 38528);
            FileInputStream srcFis = new FileInputStream("d:/temp/10M.doc");
            CMSTypedStream cmsTypeStream = new CMSTypedStream(PKCSObjectIdentifiers.data.getId(), srcFis, 0x100000);
            CMSSignedDataParser sp = new CMSSignedDataParser(cmsTypeStream, bis);
            sp.getSignedContent().drain();
            CertStore certStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            boolean verify = false;
            while (it.hasNext() && (verify = (signer = (SignerInformation)it.next()).verify(cert = (X509Certificate)(certIt = (certCollection = certStore.getCertificates(signer.getSID())).iterator()).next(), "BC"))) {
            }
            if (verify) {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
            } else {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
            sp.getSignedContent();
            Collection<? extends Certificate> certColl = certStore.getCertificates(null);
            Collection<? extends CRL> crlColl = certStore.getCRLs(null);
            sp.close();
        }
        catch (Exception ex) {
            System.out.println("err=" + ex.toString());
        }
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private DERObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, String contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = new DERObjectIdentifier(contentOID);
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            Object signer;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this._digests.clear();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                ASN1Set certs = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, certs).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                ASN1Set crls = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, crls).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            Iterator it = CMSSignedDataStreamGenerator.this._signers.iterator();
            while (it.hasNext()) {
                signer = (SignerInformation)it.next();
                signerInfos.add(((SignerInformation)signer).toSignerInfo());
            }
            it = CMSSignedDataStreamGenerator.this._signerInfs.iterator();
            while (it.hasNext()) {
                signer = (SignerInf)it.next();
                try {
                    signerInfos.add(((SignerInf)signer).toSignerInfo(this._contentOID));
                }
                catch (PKIException e) {
                    throw new IOException("PKI error." + e);
                }
                catch (IOException e) {
                    throw new IOException("encoding error." + e);
                }
                catch (SignatureException e) {
                    throw new IOException("error creating signature." + e);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("error creating sid." + e);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }

    private class SignerInf {
        JKey _prikey;
        X509Cert _cert;
        String _digestOID;
        MessageDigest _digest;
        Session session = null;
        CMSAttributeTableGenerator _sAttr;
        CMSAttributeTableGenerator _unsAttr;

        SignerInf(JKey priKey, X509Cert cert, String digestOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, MessageDigest digest, Session session) {
            this._prikey = priKey;
            this._cert = cert;
            this._digestOID = digestOID;
            this._digest = digest;
            this.session = session;
            this._sAttr = sAttr;
            this._unsAttr = unsAttr;
        }

        JKey getKey() {
            return this._prikey;
        }

        X509Cert getCertificate() {
            return this._cert;
        }

        String getDigestAlgOID() {
            return this._digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType) throws IOException, SignatureException, CertificateEncodingException, PKIException {
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
            byte[] hash = this._digest.digest();
            CMSSignedDataStreamGenerator.this._digests.put(this._digestOID, hash.clone());
            Map parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            AttributeTable signed = this._sAttr != null ? this._sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set signedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(signed);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] signData = null;
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
                Mechanism mech = null;
                mech = this._digestOID.equals("1.2.840.113549.2.5") ? new Mechanism("MD5withRSAEncryption") : new Mechanism("SHA1withRSAEncryption");
                signData = this.session.sign(mech, this._prikey, bOut.toByteArray());
            } else {
                AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(new DERObjectIdentifier(this._digestOID), new DERNull());
                DigestInfo digestInfo = new DigestInfo(digestAlg, hash);
                byte[] bDigestInfo = Parser.writeDERObj2Bytes(digestInfo);
                signData = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), this._prikey, bDigestInfo);
            }
            DEROctetString encDigest = new DEROctetString(signData);
            parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this._unsAttr != null ? this._unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(unsigned);
            X509Cert cert = this.getCertificate();
            ASN1InputStream aIn = new ASN1InputStream(cert.getTBSCertificate());
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }
}

