/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSUtils;
import com.cfca.util.pki.cms.SignerInformationStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CMSSignedGenerator {
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    private static final Set NO_PARAMS = new HashSet();
    private static final Map EC_ALGORITHMS = new HashMap();
    protected List _certs = new ArrayList();
    protected List _crls = new ArrayList();
    protected List _signers = new ArrayList();
    protected Map _digests = new HashMap();

    protected CMSSignedGenerator() {
    }

    protected String getEncOID(PrivateKey key, String digestOID) {
        String encOID = null;
        if (key instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            encOID = ENCRYPTION_RSA;
        } else if (("ECDSA".equalsIgnoreCase(key.getAlgorithm()) || "EC".equalsIgnoreCase(key.getAlgorithm())) && (encOID = (String)EC_ALGORITHMS.get(digestOID)) == null) {
            throw new IllegalArgumentException("can't mix ECDSA with anything but SHA family digests");
        }
        return encOID;
    }

    protected AlgorithmIdentifier getEncAlgorithmIdentifier(String encOid) {
        if (NO_PARAMS.contains(encOid)) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(encOid));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(encOid), new DERNull());
    }

    protected Map getBaseParameters(DERObjectIdentifier contentType, AlgorithmIdentifier digAlgId, byte[] hash) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contentType", contentType);
        param.put("digestAlgID", digAlgId);
        if (hash != null) {
            param.put("digest", hash.clone());
        }
        return param;
    }

    protected ASN1Set getAttributeSet(AttributeTable attr) {
        if (attr != null) {
            return new DERSet(attr.toASN1EncodableVector());
        }
        return null;
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        this._certs.addAll(CMSUtils.getCertificatesFromStore(certStore));
        this._crls.addAll(CMSUtils.getCRLsFromStore(certStore));
    }

    public void addSigners(SignerInformationStore signerStore) {
        Iterator it = signerStore.getSigners().iterator();
        while (it.hasNext()) {
            this._signers.add(it.next());
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }
}

