/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1Null;
import com.cfca.util.pki.asn1.ASN1Object;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cms.CMSEnvelopedDataGenerator;
import com.cfca.util.pki.cms.CMSEnvelopedHelper;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.CMSUtils;
import com.cfca.util.pki.cms.RecipientId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public abstract class RecipientInformation {
    private static final ASN1Null asn1Null = new DERNull();
    protected RecipientId _rid = new RecipientId();
    protected AlgorithmIdentifier _encAlg;
    protected AlgorithmIdentifier _keyEncAlg;
    protected InputStream _data;

    protected RecipientInformation(AlgorithmIdentifier encAlg, AlgorithmIdentifier keyEncAlg, InputStream data) {
        this._encAlg = encAlg;
        this._keyEncAlg = keyEncAlg;
        this._data = data;
    }

    public RecipientId getRID() {
        return this._rid;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(obj);
            return bOut.toByteArray();
        }
        return null;
    }

    public String getKeyEncryptionAlgOID() {
        return this._keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this._keyEncAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        try {
            byte[] enc = this.encodeObj(this._keyEncAlg.getParameters());
            if (enc == null) {
                return null;
            }
            AlgorithmParameters params = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(this.getKeyEncryptionAlgOID(), provider);
            params.init(enc, "ASN.1");
            return params;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find parameters for algorithm", e);
        }
        catch (IOException e) {
            throw new CMSException("can't find parse parameters", e);
        }
    }

    protected CMSTypedStream getContentFromSessionKey(Key sKey, String provider) throws CMSException, NoSuchProviderException {
        String encAlg = this._encAlg.getObjectId().getId();
        try {
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(encAlg, provider);
            ASN1Object sParams = (ASN1Object)this._encAlg.getParameters();
            if (sParams != null && !asn1Null.equals(sParams)) {
                AlgorithmParameters params = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(encAlg, cipher.getProvider().getName());
                params.init(sParams.getEncoded(), "ASN.1");
                cipher.init(2, sKey, params);
            } else if (encAlg.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlg.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlg.equals("1.2.840.113533.7.66.10")) {
                cipher.init(2, sKey, new IvParameterSpec(new byte[8]));
            } else {
                cipher.init(2, sKey);
            }
            return new CMSTypedStream(new CipherInputStream(this._data, cipher));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("error decoding algorithm parameters.", e);
        }
    }

    public byte[] getContent(Key key, String provider) throws CMSException, NoSuchProviderException {
        try {
            if (this._data instanceof ByteArrayInputStream) {
                this._data.reset();
            }
            return CMSUtils.streamToByteArray(this.getContentStream(key, provider).getContentStream());
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse internal stream: " + e);
        }
    }

    public abstract CMSTypedStream getContentStream(Key var1, String var2) throws CMSException, NoSuchProviderException;
}

