/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.CasteCode;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class CasteCodeExt
extends AbstractStandardExtension {
    private String castecode = null;

    public CasteCodeExt() {
        this.OID = X509Extensions.CasteCode.getId();
        this.critical = false;
    }

    public CasteCodeExt(String value) {
        this.OID = X509Extensions.CasteCode.getId();
        this.critical = false;
        this.castecode = value;
    }

    public void SetCasteCode(String value) {
        this.castecode = value;
    }

    public byte[] encode() throws PKIException {
        if (this.castecode == null) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new CasteCode(this.castecode).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

