/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1SequenceExt;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.GeneralSubtree;
import com.cfca.util.pki.asn1.x509.NameConstraints;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import java.math.BigInteger;

public class NameConstraintsExt
extends AbstractStandardExtension {
    public static final short RFC822NAME = 1;
    public static final short DNSNAME = 2;
    public static final short X400ADDRESS = 3;
    public static final short DIRECTORYNAME = 4;
    public static final short UNIFORMRESOURCEIDENTIFIER = 6;
    public static final short IPADDRESS = 7;
    private ASN1EncodableVector Permitted = new ASN1EncodableVector();
    private ASN1EncodableVector Excluded = new ASN1EncodableVector();
    private ASN1Sequence seqPermitted = null;
    private ASN1Sequence seqExcluded = null;

    public NameConstraintsExt() {
        this.OID = X509Extensions.NameConstraints.getId();
        this.critical = false;
    }

    public NameConstraintsExt(ASN1Sequence asn1Sequence) {
        int i;
        this.OID = X509Extensions.NameConstraints.getId();
        block4: for (i = 0; i < asn1Sequence.size(); ++i) {
            DERTaggedObject tempDERTaggedObject = (DERTaggedObject)asn1Sequence.getObjectAt(i).getDERObject();
            switch (tempDERTaggedObject.getTagNo()) {
                case 0: {
                    this.seqPermitted = (ASN1Sequence)tempDERTaggedObject.getObject();
                    continue block4;
                }
                case 1: {
                    this.seqExcluded = (ASN1Sequence)tempDERTaggedObject.getObject();
                }
            }
        }
        for (i = 0; i < this.seqPermitted.size(); ++i) {
            this.Permitted.add(this.seqPermitted.getObjectAt(i));
        }
        for (i = 0; i < this.seqExcluded.size(); ++i) {
            this.Excluded.add(this.seqExcluded.getObjectAt(i));
        }
    }

    public int getPermittedCount() {
        if (this.seqPermitted == null) {
            return 0;
        }
        return this.seqPermitted.size();
    }

    public int getExcludedCount() {
        if (this.seqExcluded == null) {
            return 0;
        }
        return this.seqExcluded.size();
    }

    public int getPermittedForBaseType(int index) {
        if (this.seqPermitted == null) {
            return 0;
        }
        return new GeneralSubtree((ASN1Sequence)this.seqPermitted.getObjectAt(index)).getBase().getTagNo();
    }

    public String getPermittedForBase(int index) {
        if (this.seqPermitted == null) {
            return null;
        }
        return this.GeneralNameToString(new GeneralSubtree((ASN1Sequence)this.seqPermitted.getObjectAt(index)).getBase());
    }

    public int getPermittedForMinmum(int index) {
        if (this.seqPermitted == null) {
            return 0;
        }
        return new GeneralSubtree((ASN1Sequence)this.seqPermitted.getObjectAt(index)).getMinimum().intValue();
    }

    public int getPermittedForMaxmum(int index) {
        if (this.seqPermitted == null) {
            return 0;
        }
        BigInteger max = new GeneralSubtree((ASN1Sequence)this.seqPermitted.getObjectAt(index)).getMaximum();
        if (max == null) {
            return -1;
        }
        return max.intValue();
    }

    public int getExcludedForBaseType(int index) {
        if (this.seqExcluded == null) {
            return 0;
        }
        return new GeneralSubtree((ASN1Sequence)this.seqExcluded.getObjectAt(index)).getBase().getTagNo();
    }

    public String getExcludedForBase(int index) {
        if (this.seqExcluded == null) {
            return null;
        }
        return this.GeneralNameToString(new GeneralSubtree((ASN1Sequence)this.seqExcluded.getObjectAt(index)).getBase());
    }

    public int getExcludedForMinmum(int index) {
        if (this.seqExcluded == null) {
            return 0;
        }
        return new GeneralSubtree((ASN1Sequence)this.seqExcluded.getObjectAt(index)).getMinimum().intValue();
    }

    public int getExcludedForMaxmum(int index) {
        if (this.seqExcluded == null) {
            return 0;
        }
        BigInteger max = new GeneralSubtree((ASN1Sequence)this.seqExcluded.getObjectAt(index)).getMaximum();
        if (max == null) {
            return -1;
        }
        return max.intValue();
    }

    private String GeneralNameToString(GeneralName tempGeneralName) {
        String retString = null;
        switch (tempGeneralName.getTagNo()) {
            case 1: 
            case 2: 
            case 6: {
                retString = ((DERIA5String)tempGeneralName.getName()).getString();
                break;
            }
            case 7: {
                int i;
                StringBuffer tempSB = new StringBuffer();
                byte[] tempByte = ((DEROctetString)tempGeneralName.getName()).getOctets();
                int tempInt = 0;
                for (i = 0; i < 4; ++i) {
                    tempInt = tempByte[i];
                    if (tempInt < 0) {
                        tempInt = 256 + tempInt;
                    }
                    tempSB.append(String.valueOf(tempInt));
                    if (i >= 3) continue;
                    tempSB.append(".");
                }
                if (tempByte.length > 4) {
                    tempSB.append("/");
                    for (i = 4; i < tempByte.length; ++i) {
                        tempInt = tempByte[i];
                        if (tempInt < 0) {
                            tempInt = 256 + tempInt;
                        }
                        tempSB.append(String.valueOf(tempInt));
                        if (i >= tempByte.length - 1) continue;
                        tempSB.append(".");
                    }
                }
                retString = tempSB.toString();
                break;
            }
            case 8: {
                retString = ((DERObjectIdentifier)tempGeneralName.getName()).getId();
                break;
            }
            case 4: {
                retString = X509Name.getInstance(tempGeneralName.getName()).toString();
            }
        }
        return retString;
    }

    public void addPermitted(short valueType, String value, Integer max, Integer min) throws PKIException {
        this.Permitted.add(this.GenDerObject(valueType, value, max, min));
    }

    public void addExcluded(short valueType, String value, Integer max, Integer min) throws PKIException {
        this.Excluded.add(this.GenDerObject(valueType, value, max, min));
    }

    public byte[] encode() throws PKIException {
        if (this.Permitted.size() <= 0 || this.Excluded.size() <= 0) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        ASN1SequenceExt NameConstraints2 = new ASN1SequenceExt();
        DERTaggedObject dto_Permitted = new DERTaggedObject(false, 0, new DERSequence(this.Permitted));
        DERTaggedObject dto_Excluded = new DERTaggedObject(false, 1, new DERSequence(this.Excluded));
        NameConstraints2.addObject(dto_Permitted);
        NameConstraints2.addObject(dto_Excluded);
        return new DEROctetString(new NameConstraints(NameConstraints2).getDERObject()).getOctets();
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    private DERObject GenDerObject(short valueType, String value, Integer max, Integer min) throws PKIException {
        ASN1SequenceExt temp = new ASN1SequenceExt();
        temp.addObject(new DERTaggedObject(valueType, this.TypeConversion(valueType, value)));
        if (min != null) {
            temp.addObject(new DERTaggedObject(0, new DERInteger(min)));
        }
        if (max != null) {
            temp.addObject(new DERTaggedObject(1, new DERInteger(max)));
        }
        return new GeneralSubtree(temp).getDERObject();
    }

    private DEREncodable TypeConversion(short valueType, String value) throws PKIException {
        DEREncodable derencodable = null;
        switch (valueType) {
            case 1: 
            case 2: 
            case 6: {
                derencodable = new DERIA5String(value);
                break;
            }
            case 7: {
                derencodable = new DEROctetString(this.IP4Address(value));
                break;
            }
            case 3: {
                throw new PKIException("850504", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
            case 4: {
                derencodable = new X509Name(value);
            }
        }
        if (derencodable == null) {
            throw new PKIException("850504", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
        }
        return derencodable;
    }

    private byte[] IP4Address(String value) {
        String[] allip = value.split("/");
        byte[] ip4_byte = null;
        if (allip.length == 2) {
            ip4_byte = new byte[8];
            this.GenIP4Address(ip4_byte, allip[0]);
            byte[] ip4_mask = new byte[4];
            this.GenIP4Address(ip4_mask, allip[1]);
            System.arraycopy(ip4_mask, 0, ip4_byte, 4, 4);
        } else if (allip.length == 1) {
            ip4_byte = new byte[4];
            this.GenIP4Address(ip4_byte, value);
        }
        return ip4_byte;
    }

    private void GenIP4Address(byte[] ip4_byte, String value) {
        int pos = 0;
        for (int i = 0; i < 4; ++i) {
            pos = value.indexOf(".");
            ip4_byte[i] = pos == -1 ? Integer.valueOf(value).byteValue() : Integer.valueOf(value.substring(0, pos)).byteValue();
            value = value.substring(pos + 1, value.length());
        }
    }
}

