/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.NetscapeCertType;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import java.util.Vector;

public class NetscapeCertTypeExt
extends AbstractStandardExtension {
    public static final String SSL_CLIENT = "sslClient";
    public static final String SSL_SERVER = "sslServer";
    public static final String SMIME = "smime";
    public static final String OBJECT_SIGNING = "objectSigning";
    public static final String SSL_CA = "sslCA";
    public static final String SMIME_CA = "smimeCA";
    public static final String OBJECT_SIGNING_CA = "objectSigningCA";
    private Vector certTypeVector = null;
    private int certType = 0;

    public NetscapeCertTypeExt() {
        this.OID = X509Extensions.NetscapeCertType.getId();
        this.critical = false;
        this.certType = 0;
        this.certTypeVector = new Vector();
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public void addCertType(String certType) {
        this.certTypeVector.add(certType);
    }

    public void setCertType(Vector certTypes) {
        for (int i = 0; i < certTypes.size(); ++i) {
            this.certTypeVector.add((String)certTypes.get(i));
        }
    }

    public byte[] encode() throws PKIException {
        if (this.certTypeVector.contains(SSL_CLIENT)) {
            this.certType |= 0x80;
        }
        if (this.certTypeVector.contains(SSL_SERVER)) {
            this.certType |= 0x40;
        }
        if (this.certTypeVector.contains(SMIME)) {
            this.certType |= 0x20;
        }
        if (this.certTypeVector.contains(OBJECT_SIGNING)) {
            this.certType |= 0x10;
        }
        if (this.certTypeVector.contains(SSL_CA)) {
            this.certType |= 4;
        }
        if (this.certTypeVector.contains(SMIME_CA)) {
            this.certType |= 2;
        }
        if (this.certTypeVector.contains(OBJECT_SIGNING_CA)) {
            this.certType |= 1;
        }
        NetscapeCertType nsCertType = new NetscapeCertType(this.certType);
        DEROctetString octetValue = new DEROctetString(nsCertType.getDERObject());
        return octetValue.getOctets();
    }
}

