/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.GeneralNamesExt;

public class SubjectAltNameExt
extends GeneralNamesExt {
    public static final String DNS_TYPE_NAME = "2";
    public static final String URI_TYPE_NAME = "6";
    public static final String DN_TYPE_NAME = "4";

    public SubjectAltNameExt() {
        this.OID = X509Extensions.SubjectAlternativeName.getId();
    }

    public SubjectAltNameExt(ASN1Sequence asn1Sequence) {
        super(asn1Sequence);
        this.OID = X509Extensions.SubjectAlternativeName.getId();
    }

    public void setOtherName(String nameOID, String otherName) throws PKIException {
        if (nameOID.equals("1.3.6.1.4.1.311.20.2.3")) {
            this.addGeneralName(100, otherName);
        } else if (nameOID.equals("1.3.6.1.4.1.311.25.1")) {
            this.addGeneralName(101, otherName);
        }
    }

    public void setName(String nameType, String name) throws PKIException {
        if (nameType.equals(DNS_TYPE_NAME)) {
            this.addGeneralName(2, name);
        } else if (nameType.equals(URI_TYPE_NAME)) {
            this.addGeneralName(6, name);
        } else if (nameType.equals(DN_TYPE_NAME)) {
            this.addGeneralName(4, name);
        }
    }
}

