/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.AccessDescription;
import com.cfca.util.pki.asn1.x509.AuthorityInformationAccess;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import com.cfca.util.pki.extension.AccessDescriptionExt;
import java.util.Vector;

public class SubjectInformationAccessExt
extends AbstractStandardExtension {
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;
    public static final int RFC822_TYPE_NAME = 1;
    public static final int IPADDRESS_TYPE_NAME = 7;
    public static final int DNSNALE_TYPE_NAME = 2;
    private Vector accessDescriptionExts = null;

    public SubjectInformationAccessExt() {
        this.OID = X509Extensions.SubjectInformationAccess.getId();
        this.critical = false;
        this.accessDescriptionExts = new Vector();
    }

    public SubjectInformationAccessExt(ASN1Sequence asn1Sequence) {
        this.accessDescriptionExts = new Vector();
        int size = asn1Sequence.size();
        for (int i = 0; i < size; ++i) {
            ASN1Sequence seq = (ASN1Sequence)asn1Sequence.getObjectAt(i);
            DERObjectIdentifier method = (DERObjectIdentifier)seq.getObjectAt(0);
            AccessDescriptionExt accessDescription = new AccessDescriptionExt();
            accessDescription.setAccessMethod(method.getId());
            ASN1TaggedObject tagObj = (ASN1TaggedObject)seq.getObjectAt(1);
            String location = GeneralName.GeneralNameToString(tagObj);
            accessDescription.setAccessLocation(location);
            this.accessDescriptionExts.add(accessDescription);
        }
    }

    public void addAccessDescription(AccessDescriptionExt accessDescription) {
        this.accessDescriptionExts.add(accessDescription);
    }

    public AccessDescriptionExt[] getAccessDescription() {
        AccessDescriptionExt[] accessDescriptions = new AccessDescriptionExt[this.accessDescriptionExts.size()];
        return this.accessDescriptionExts.toArray(accessDescriptions);
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        Vector<AccessDescription> vAccessDesExt = new Vector<AccessDescription>();
        for (int i = 0; i < this.accessDescriptionExts.size(); ++i) {
            DERIA5String ia5DPName;
            AccessDescriptionExt accessDesExt = (AccessDescriptionExt)this.accessDescriptionExts.get(i);
            DERObjectIdentifier idAccessMethod = new DERObjectIdentifier(accessDesExt.getAccessMethod());
            GeneralName nameAccessLocation = null;
            if (accessDesExt.getAccessLocationType() == 6) {
                ia5DPName = new DERIA5String(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ia5DPName, 6);
            } else if (accessDesExt.getAccessLocationType() == 4) {
                nameAccessLocation = new GeneralName(new X509Name(accessDesExt.getAccessLocation()));
            } else if (accessDesExt.getAccessLocationType() == 1) {
                ia5DPName = new DERIA5String(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ia5DPName, 1);
            } else if (accessDesExt.getAccessLocationType() == 7) {
                DEROctetString ipAddress = new DEROctetString(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ipAddress, 7);
            } else if (accessDesExt.getAccessLocationType() == 2) {
                ia5DPName = new DERIA5String(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ia5DPName, 2);
            }
            AccessDescription accessDes = new AccessDescription();
            accessDes.setAccessMethod(idAccessMethod);
            accessDes.setAccessLocation(nameAccessLocation);
            vAccessDesExt.add(accessDes);
        }
        AuthorityInformationAccess authInfoAccess = new AuthorityInformationAccess(vAccessDesExt);
        DEROctetString octetValue = new DEROctetString(authInfoAccess.getDERObject());
        return octetValue.getOctets();
    }
}

