/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.SubjectKeyIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class SubjectKeyIdentifierExt
extends AbstractStandardExtension {
    private JKey subjectPublicKey = null;
    private SubjectKeyIdentifier ski = null;

    public SubjectKeyIdentifierExt(JKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
        this.OID = X509Extensions.SubjectKeyIdentifier.getId();
        this.critical = false;
    }

    public SubjectKeyIdentifierExt(DEROctetString obj) {
        this.OID = X509Extensions.SubjectKeyIdentifier.getId();
        this.ski = new SubjectKeyIdentifier(obj.getOctets());
    }

    public byte[] getSubKeyIdentifier() {
        if (this.ski != null) {
            return this.ski.getKeyIdentifier();
        }
        return null;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public JKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public byte[] encode() throws PKIException {
        SubjectPublicKeyInfo spki = null;
        spki = Parser.key2SPKI(this.subjectPublicKey);
        SubjectKeyIdentifier subjectKeyID = new SubjectKeyIdentifier(spki);
        DEROctetString octetValue = new DEROctetString(subjectKeyID.getDERObject());
        return octetValue.getOctets();
    }
}

