/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.ocsp.BasicOCSPResponse;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.ocsp.RespData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

public class BasicOCSPResp {
    BasicOCSPResponse resp;
    X509Cert[] chain = null;

    public BasicOCSPResp(BasicOCSPResponse resp) {
        this.resp = resp;
    }

    public String getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.resp.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    public X509Cert[] getCerts() throws PKIException {
        if (this.chain == null) {
            ArrayList<X509Cert> certs = new ArrayList<X509Cert>();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            ASN1Sequence s = this.resp.getCerts();
            if (s != null) {
                Enumeration e = s.getObjects();
                while (e.hasMoreElements()) {
                    try {
                        aOut.writeObject(e.nextElement());
                        certs.add(new X509Cert(new ByteArrayInputStream(bOut.toByteArray())));
                    }
                    catch (Exception ex) {
                        throw new PKIException("850807", "\u4eceOCSP\u54cd\u5e94\u4e2d\u83b7\u5f97\u8bc1\u4e66\u5931\u8d25", ex);
                    }
                    bOut.reset();
                }
            }
            this.chain = certs.toArray(new X509Cert[certs.size()]);
        }
        return this.chain;
    }

    public boolean verify(JKey key, Session session) throws PKIException {
        try {
            String strAlgOID = this.getSignatureAlgOID();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.resp.getTbsResponseData());
            Mechanism mechanism = null;
            if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
                mechanism = new Mechanism("SHA1withRSAEncryption");
            } else if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.md2WithRSAEncryption.getId())) {
                mechanism = new Mechanism("MD2withRSAEncryption");
            } else if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.md5WithRSAEncryption.getId())) {
                mechanism = new Mechanism("MD5withRSAEncryption");
            } else {
                throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
            }
            return session.verifySign(mechanism, key, bOut.toByteArray(), this.getSignature());
        }
        catch (Exception e) {
            throw new PKIException("850806", "\u9a8c\u8bc1OCSP\u54cd\u5e94\u7684\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public byte[] getEncoded() throws PKIException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this.resp);
        }
        catch (IOException ex) {
            throw new PKIException("850805", "\u83b7\u5f97\u57fa\u672cOCSP\u54cd\u5e94\u7684\u7f16\u7801\u5931\u8d25", ex);
        }
        return bOut.toByteArray();
    }
}

