/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.ocsp.CertID;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import java.math.BigInteger;

public class CertificateID {
    public static String HASH_SHA1 = "1.3.14.3.2.26";
    public static String HASH_MD5 = "1.2.840.113549.2.5";
    public static String HASH_MD2 = "1.2.840.113549.2.2";
    private CertID id;

    public CertificateID(CertID id) {
        this.id = id;
    }

    public CertificateID(String hashAlgorithm, String issuerName, byte[] issuerKey, BigInteger iSerialNumber, Session session) throws PKIException {
        try {
            AlgorithmIdentifier hashAlg = null;
            Mechanism hashMechanism = null;
            if (hashAlgorithm.equals(HASH_MD5)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD5");
            } else if (hashAlgorithm.equals(HASH_MD2)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD2");
            } else {
                hashAlgorithm = HASH_SHA1;
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("SHA1");
            }
            byte[] bIssuerNameHash = session.digest(hashMechanism, issuerName.getBytes());
            DEROctetString issuerNameHash = new DEROctetString(bIssuerNameHash);
            byte[] bIssuerKeyHash = session.digest(hashMechanism, issuerKey);
            DEROctetString issuerKeyHash = new DEROctetString(bIssuerKeyHash);
            DERInteger serialNumber = new DERInteger(iSerialNumber);
            this.id = new CertID(hashAlg, issuerNameHash, issuerKeyHash, serialNumber);
        }
        catch (Exception e) {
            throw new PKIException("850810", "\u6784\u9020\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u4e2d\u7684\u8bc1\u4e66ID\u5931\u8d25", e);
        }
    }

    public CertificateID(String hashAlgorithm, X509Cert issuerCert, BigInteger iSerialNumber, Session session) throws PKIException {
        try {
            AlgorithmIdentifier hashAlg = null;
            Mechanism hashMechanism = null;
            if (hashAlgorithm.equals(HASH_MD5)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD5");
            } else if (hashAlgorithm.equals(HASH_MD2)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD2");
            } else {
                hashAlgorithm = HASH_SHA1;
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("SHA1");
            }
            String issuerName = issuerCert.getSubject();
            byte[] bIssuerNameHash = session.digest(hashMechanism, issuerName.getBytes());
            DEROctetString issuerNameHash = new DEROctetString(bIssuerNameHash);
            JKey issuerKey = issuerCert.getPublicKey();
            byte[] bPubKey = issuerKey.getKey();
            byte[] bIssuerKeyHash = session.digest(hashMechanism, bPubKey);
            DEROctetString issuerKeyHash = new DEROctetString(bIssuerKeyHash);
            DERInteger serialNumber = new DERInteger(iSerialNumber);
            this.id = new CertID(hashAlg, issuerNameHash, issuerKeyHash, serialNumber);
        }
        catch (Exception e) {
            throw new PKIException("850810", "\u6784\u9020\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u4e2d\u7684\u8bc1\u4e66ID\u5931\u8d25", e);
        }
    }

    public CertificateID(String hashAlgorithm, X509Cert issuerCert, String str16SerialNumber, Session session) throws PKIException {
        try {
            AlgorithmIdentifier hashAlg = null;
            Mechanism hashMechanism = null;
            if (hashAlgorithm.equals(HASH_MD5)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD5");
            } else if (hashAlgorithm.equals(HASH_MD2)) {
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("MD2");
            } else {
                hashAlgorithm = HASH_SHA1;
                hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
                hashMechanism = new Mechanism("SHA1");
            }
            String issuerName = issuerCert.getSubject();
            byte[] bIssuerNameHash = session.digest(hashMechanism, issuerName.getBytes());
            DEROctetString issuerNameHash = new DEROctetString(bIssuerNameHash);
            JKey issuerKey = issuerCert.getPublicKey();
            byte[] bPubKey = issuerKey.getKey();
            byte[] bIssuerKeyHash = session.digest(hashMechanism, bPubKey);
            DEROctetString issuerKeyHash = new DEROctetString(bIssuerKeyHash);
            BigInteger bigInt = new BigInteger(str16SerialNumber, 16);
            DERInteger serialNumber = new DERInteger(bigInt);
            this.id = new CertID(hashAlg, issuerNameHash, issuerKeyHash, serialNumber);
        }
        catch (Exception e) {
            throw new PKIException("850810", "\u6784\u9020\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u4e2d\u7684\u8bc1\u4e66ID\u5931\u8d25", e);
        }
    }

    public String getHashAlgOID() {
        return this.id.getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CertificateID)) {
            return false;
        }
        CertificateID obj = (CertificateID)o;
        return this.id.getDERObject().equals(obj.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }
}

