/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.ocsp.OCSPRequest;
import com.cfca.util.pki.asn1.ocsp.Request;
import com.cfca.util.pki.asn1.ocsp.Signature;
import com.cfca.util.pki.asn1.ocsp.TBSRequest;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.ocsp.CertificateID;
import com.cfca.util.pki.ocsp.OCSPReq;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class OCSPReqGenerator {
    private ArrayList list = new ArrayList();
    private GeneralName requestorName = null;
    private X509Extensions requestExtensions = null;
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;

    public void addRequest(CertificateID certId) {
        this.list.add(new RequestObject(certId, null));
    }

    public void addRequest(CertificateID certId, X509Extensions requestExtensions) {
        this.list.add(new RequestObject(certId, requestExtensions));
    }

    public void setRequestorName(String name, int nameType) {
        if (nameType == 4) {
            X509Name x509DPName = new X509Name(name);
            this.requestorName = new GeneralName(x509DPName);
        } else if (nameType == 6) {
            byte[] bName = name.getBytes();
            DERIA5String ia5Name = new DERIA5String(bName);
            this.requestorName = new GeneralName(ia5Name, 6);
        }
    }

    public void setRequestExtensions(X509Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
    }

    public OCSPReq generateRequest() throws PKIException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new PKIException("850800", "\u6784\u9020\u8bf7\u6c42\u5217\u8868\u5931\u8d25", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, new DERSequence(requests), this.requestExtensions);
        return new OCSPReq(new OCSPRequest(tbsReq, null));
    }

    public OCSPReq generateRequest(String signingAlgorithm, JKey priKey, Session session) throws PKIException {
        return this.generateRequest(signingAlgorithm, priKey, null, session);
    }

    public OCSPReq generateRequest(String signingAlgorithm, JKey priKey, X509Cert[] chain, Session session) throws PKIException {
        DERObjectIdentifier sigAlgOID = (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signingAlgorithm);
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new PKIException("850800", "\u6784\u9020\u8bf7\u6c42\u5217\u8868\u5931\u8d25", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, new DERSequence(requests), this.requestExtensions);
        Mechanism mechanism = null;
        if (signingAlgorithm.equalsIgnoreCase("MD2withRSAEncryption")) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signingAlgorithm.equalsIgnoreCase("MD5withRSAEncryption")) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signingAlgorithm.equalsIgnoreCase("SHA1withRSAEncryption")) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        byte[] sigValue = null;
        try {
            sigValue = session.sign(new Mechanism(signingAlgorithm), priKey, tbsReq.getEncoded());
        }
        catch (IOException ex) {
            throw new PKIException("850812", "OCSP TBSReq\u7f16\u7801\u5931\u8d25", ex);
        }
        catch (PKIException ex) {
            throw new PKIException("05", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        DERBitString bitSig = new DERBitString(sigValue);
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(sigAlgOID, new DERNull());
        Signature signature = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i != chain.length; ++i) {
                v.add(chain[i].getCertStructure());
            }
            signature = new Signature(sigAlgId, bitSig, new DERSequence(v));
        } else {
            signature = new Signature(sigAlgId, bitSig);
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    private class RequestObject {
        CertificateID certId;
        X509Extensions extensions;

        public RequestObject(CertificateID certId, X509Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() throws Exception {
            return new Request(this.certId.toASN1Object(), this.extensions);
        }
    }
}

