/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.ocsp.OCSPObjectIdentifiers;
import com.cfca.util.pki.asn1.ocsp.OCSPResponse;
import com.cfca.util.pki.asn1.ocsp.OCSPResponseStatus;
import com.cfca.util.pki.asn1.ocsp.ResponseBytes;
import com.cfca.util.pki.ocsp.BasicOCSPResp;
import com.cfca.util.pki.ocsp.OCSPResp;

public class OCSPRespGenerator {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp generate(int status, Object response) throws PKIException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        BasicOCSPResp r = (BasicOCSPResp)response;
        DEROctetString octs = new DEROctetString(r.getEncoded());
        ResponseBytes rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, octs);
        return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), rb));
    }
}

