/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ocsp.ResponseData;
import com.cfca.util.pki.asn1.ocsp.SingleResponse;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.ocsp.RespID;
import com.cfca.util.pki.ocsp.SingleResp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RespData {
    ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        return dateF.parse(this.data.getProducedAt().getTime(), new ParsePosition(0));
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

