/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.ocsp.RevokedInfo;
import com.cfca.util.pki.asn1.x509.CRLReason;
import com.cfca.util.pki.ocsp.CertificateStatus;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(Date revocationTime, int crlReason) {
        DERGeneralizedTime time = new DERGeneralizedTime(revocationTime);
        CRLReason reason = new CRLReason(crlReason);
        this.info = new RevokedInfo(time, reason);
    }

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public Date getRevocationTime() {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        DERGeneralizedTime gt = this.info.getRevocationTime();
        String time = gt.getTime();
        return dateF.parse(time, new ParsePosition(0));
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

