/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.asn1.ocsp.CertStatus;
import com.cfca.util.pki.asn1.ocsp.RevokedInfo;
import com.cfca.util.pki.asn1.ocsp.SingleResponse;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.ocsp.CertificateID;
import com.cfca.util.pki.ocsp.RevokedStatus;
import com.cfca.util.pki.ocsp.UnknownStatus;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SingleResp {
    SingleResponse resp;

    public SingleResp(SingleResponse resp) {
        this.resp = resp;
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public Object getCertStatus() {
        CertStatus s = this.resp.getCertStatus();
        if (s.getTagNo() == 0) {
            return null;
        }
        if (s.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(s.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        return dateF.parse(this.resp.getThisUpdate().getTime(), new ParsePosition(0));
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        return dateF.parse(this.resp.getNextUpdate().getTime(), new ParsePosition(0));
    }

    public X509Extensions getSingleExtensions() {
        return this.resp.getSingleExtensions();
    }
}

