/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIBaseConfig;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs10.CertificationRequest;
import com.cfca.util.pki.asn1.pkcs.pkcs10.CertificationRequestInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class PKCS10 {
    private String subject = null;
    private JKey pubKey = null;
    private ASN1Set attributes = null;
    private Session session = null;
    private boolean needVerify = false;
    private static Hashtable algs = new Hashtable();
    private static Hashtable oids = new Hashtable();
    public static final String SHA1_RSA = "SHA1withRSAEncryption";
    public static final String MD2_RSA = "MD2withRSAEncryption";
    public static final String MD5_RSA = "MD5withRSAEncryption";
    public static final String SHA1_DSA = "SHA1withDSA";
    public static final String SHA1_EC_DES = "SHA1withECDSA";
    public static boolean LoadedConfigFile = false;

    public PKCS10(Session session) {
        this.session = session;
    }

    public CertificationRequest generateCertificationRequest(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        this.subject = subject;
        this.pubKey = pubKey;
        this.attributes = attributes;
        X509Name p10Subject = new X509Name(subject);
        DERObjectIdentifier signOID = (DERObjectIdentifier)algs.get(signatureAlgorithm);
        if (signOID == null) {
            throw new PKIException("850602", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5 " + signatureAlgorithm);
        }
        if (subject == null) {
            throw new PKIException("850602", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e3b\u9898\u4fe1\u606f\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        if (pubKey == null) {
            throw new PKIException("850602", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u516c\u94a5\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        if (signingKey == null) {
            throw new PKIException("850602", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u7b7e\u540d\u79c1\u94a5\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        AlgorithmIdentifier algID = new AlgorithmIdentifier(signOID, null);
        SubjectPublicKeyInfo spki = Parser.key2SPKI(pubKey);
        CertificationRequestInfo crqInfo = new CertificationRequestInfo(p10Subject, spki, attributes);
        byte[] b_crqInfo = Parser.writeDERObj2Bytes(crqInfo.getDERObject());
        byte[] signData = this.session.sign((Mechanism)oids.get(signOID), signingKey, b_crqInfo);
        DERBitString signature = new DERBitString(signData);
        return new CertificationRequest(crqInfo, algID, signature);
    }

    public byte[] generateCertificationRequestData_DER(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        CertificationRequest certReq = this.generateCertificationRequest(signatureAlgorithm, subject, pubKey, attributes, signingKey);
        byte[] data = Parser.writeDERObj2Bytes(certReq.getDERObject());
        return data;
    }

    public byte[] generateCertificationRequestData_B64(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        CertificationRequest certReq = this.generateCertificationRequest(signatureAlgorithm, subject, pubKey, attributes, signingKey);
        byte[] data = Parser.writeDERObj2Bytes(certReq.getDERObject());
        data = Base64.encode(data);
        return data;
    }

    public void load(CertificationRequest certficationRequest) throws PKIException {
        boolean f;
        DERObjectIdentifier signOID = certficationRequest.getSignatureAlgorithm().getObjectId();
        Mechanism signM = (Mechanism)oids.get(signOID);
        if (signM == null) {
            throw new PKIException("850602", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5 " + signOID.toString());
        }
        byte[] signData = certficationRequest.getSignature().getBytes();
        CertificationRequestInfo crqInfo = certficationRequest.getCertificationRequestInfo();
        byte[] b_crqInfo = Parser.writeDERObj2Bytes(crqInfo.getDERObject());
        SubjectPublicKeyInfo spki = crqInfo.getSubjectPublicKeyInfo();
        this.pubKey = Parser.SPKI2Key(spki);
        this.needVerify = PKIBaseConfig.isVerifyP10Signature();
        if (this.needVerify && !(f = this.session.verifySign(signM, this.pubKey, b_crqInfo, signData))) {
            throw new PKIException("850603", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25 \u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        this.subject = crqInfo.getSubject().toString();
        this.attributes = crqInfo.getAttributes();
    }

    public void load(byte[] data) throws PKIException {
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String str = bufferReader.readLine();
            if (str.toUpperCase().indexOf("BEGIN NEW CERTIFICATE REQUEST") != -1) {
                StringBuffer strBuffer = new StringBuffer();
                while ((str = bufferReader.readLine()) != null && str.toUpperCase().indexOf("END NEW CERTIFICATE REQUEST") == -1) {
                    strBuffer.append(str);
                }
                data = strBuffer.toString().getBytes();
                data = Parser.convertBase64(data);
                data = Base64.decode(data);
            } else {
                boolean isB64 = Parser.isBase64Encode(data);
                if (isB64) {
                    data = Parser.convertBase64(data);
                    data = Base64.decode(data);
                }
            }
        }
        catch (IOException ex1) {
            throw new PKIException("850603", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25", ex1);
        }
        CertificationRequest certificationRequest = null;
        try {
            if (data[0] != 48) {
                throw new Exception();
            }
            ASN1Sequence sequence = (ASN1Sequence)Parser.writeBytes2DERObj(data);
            certificationRequest = new CertificationRequest(sequence);
        }
        catch (Exception ex) {
            throw new PKIException("850603", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25", new Exception("The PKCS10 CertificationRequest content error."));
        }
        this.load(certificationRequest);
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public JKey getPubKey() {
        return this.pubKey;
    }

    public String getSubject() {
        return this.subject;
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism mechanism = new Mechanism("RSA");
            JKeyPair keypair = session.generateKeyPair(mechanism, 1024);
            PKCS10 p10 = new PKCS10(session);
            byte[] reqText = p10.generateCertificationRequestData_B64(SHA1_RSA, "CN=041@112341234@1243124@00000001,OU=Customers,O=CFCA,C=CN", keypair.getPublicKey(), null, keypair.getPrivateKey());
            FileOutputStream fos = new FileOutputStream("C:/test/reqTest");
            fos.write(reqText);
            fos.close();
            p10.load(reqText);
            JKey pubKey = p10.getPubKey();
            String subject = p10.getSubject();
            System.out.println("OK");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    static {
        algs.put(SHA1_RSA, PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algs.put(MD5_RSA, PKCSObjectIdentifiers.md5WithRSAEncryption);
        algs.put(MD2_RSA, PKCSObjectIdentifiers.md2WithRSAEncryption);
        algs.put(SHA1_DSA, PKCSObjectIdentifiers.sha1WithDSA);
        algs.put(SHA1_EC_DES, PKCSObjectIdentifiers.sha1WithECEncryption);
        oids.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, new Mechanism(SHA1_RSA));
        oids.put(PKCSObjectIdentifiers.md5WithRSAEncryption, new Mechanism(MD5_RSA));
        oids.put(PKCSObjectIdentifiers.md2WithRSAEncryption, new Mechanism(MD2_RSA));
        oids.put(PKCSObjectIdentifiers.sha1WithDSA, new Mechanism(SHA1_DSA));
        oids.put(PKCSObjectIdentifiers.sha1WithECEncryption, new Mechanism(SHA1_EC_DES));
    }
}

