/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs12.Pfx;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EncryptedContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EncryptedData;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.cipher.param.PBEParam;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7EnvelopedData;
import com.cfca.util.pki.pkcs.PKCS7SignedData;

public class PKCS7EncryptedData {
    private Session session = null;
    public static final String DATA = PKCS7SignedData.DATA;
    public static final String SIGNED_DATA = PKCS7SignedData.SIGNED_DATA;
    public static final String ENVELOPED_DATA = PKCS7SignedData.ENVELOPED_DATA;
    public static final String SIGNED_ENVELOPED_DATA = PKCS7SignedData.SIGNED_ENVELOPED_DATA;
    public static final String DIGESTED_DATA = PKCS7SignedData.DIGESTED_DATA;
    public static final String ENCRYPTED_DATA = PKCS7SignedData.ENCRYPTED_DATA;

    public PKCS7EncryptedData(Session session) {
        this.session = session;
    }

    public EncryptedContentInfo generateEncryptedContentInfo(String contentType, Mechanism encryptionMech, byte[] data, JKey jkey) throws PKIException {
        DERObjectIdentifier encryptOID = this.getAlgOID(encryptionMech);
        AlgorithmIdentifier encryptionAlg = new AlgorithmIdentifier(encryptOID, null);
        if (encryptionMech.getMechanismType().toUpperCase().indexOf("PBE") != -1) {
            return this.generatePBEECI(new DERObjectIdentifier(contentType), encryptionMech, encryptOID, jkey, data);
        }
        if (encryptionMech.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
            Object param = encryptionMech.getParam();
            if (param == null) {
                throw new PKIException("850611", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e2d\u7684CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            CBCParam cbcParam = (CBCParam)encryptionMech.getParam();
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            encryptionAlg = new AlgorithmIdentifier(encryptOID, doct);
        }
        byte[] encryptedData = this.session.encrypt(encryptionMech, jkey, data);
        DEROctetString encryptedContent = new DEROctetString(encryptedData);
        return new EncryptedContentInfo(new DERObjectIdentifier(contentType), encryptionAlg, encryptedContent);
    }

    private EncryptedContentInfo generatePBEECI(DERObjectIdentifier contentType, Mechanism cryptoM, DERObjectIdentifier cryptoOID, JKey jkey, byte[] data) throws PKIException {
        PBEParam pbeParam = new PBEParam();
        ASN1EncodableVector derV = new ASN1EncodableVector();
        DEROctetString derO = new DEROctetString(pbeParam.getSalt());
        DERInteger derI = new DERInteger(pbeParam.getIterations());
        derV.add(derO);
        derV.add(derI);
        DERSequence derS = new DERSequence(derV);
        AlgorithmIdentifier encryptionAlg = new AlgorithmIdentifier(cryptoOID, derS);
        byte[] encryptedData = this.session.encrypt(cryptoM, jkey, data);
        derO = new DEROctetString(encryptedData);
        return new EncryptedContentInfo(contentType, encryptionAlg, derO);
    }

    private DERObjectIdentifier getAlgOID(Mechanism mechanism) throws PKIException {
        String mechType = mechanism.getMechanismType();
        if (mechType.equals("DES/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desEncryption;
        }
        if (mechType.equals("DES/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desCBCEncryption;
        }
        if (mechType.equals("DESede/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.des3Encryption;
        }
        if (mechType.equals("DESede/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.des3CBCEncryption;
        }
        if (mechType.equals("RC2/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desCBCEncryption;
        }
        if (mechType.equals("RC2/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desCBCEncryption;
        }
        if (mechType.equals("PBEWithSHA1AndDES")) {
            return PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC;
        }
        if (mechType.equals("PBEWithSHA1AndRC2")) {
            return PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC;
        }
        if (mechType.equals("PBEWithMD5AndDES")) {
            return PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC;
        }
        if (mechType.equals("PBEWithMD5AndRC2")) {
            return PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC;
        }
        throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
    }

    public ContentInfo generateEncryptedDataContent(EncryptedData encryptedData) {
        return new ContentInfo(PKCSObjectIdentifiers.encryptedData, encryptedData);
    }

    public EncryptedData getEncryptedDataFromContent(ContentInfo contentInfo) throws PKIException {
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new PKIException("850616", "\u89e3\u6790\u52a0\u5bc6\u6570\u636e,\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u52a0\u5bc6\u6570\u636e");
        }
        return EncryptedData.getInstance(contentInfo.getContent());
    }

    public byte[] getContent(EncryptedContentInfo encryptedContentInfo, JKey jkey) throws PKIException {
        try {
            if (encryptedContentInfo == null) {
                throw new PKIException("850616", "\u89e3\u6790\u52a0\u5bc6\u6570\u636e,\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            }
            byte[] encryptedData = null;
            if (encryptedContentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
                if (encryptedContentInfo.getEncryptedContent() == null) {
                    throw new PKIException("8506");
                }
                encryptedData = encryptedContentInfo.getEncryptedContent().getOctets();
            } else {
                encryptedData = Parser.writeDERObj2Bytes(encryptedContentInfo.getEncryptedContent().getDERObject());
            }
            DERObjectIdentifier encryptionAlgId = encryptedContentInfo.getContentEncryptionAlgorithm().getObjectId();
            AlgorithmIdentifier alg = encryptedContentInfo.getContentEncryptionAlgorithm();
            DEROctetString doct = (DEROctetString)alg.getParameters();
            Mechanism mechanism = null;
            String algorithm = PKCS7EnvelopedData.OID_MECH.get(encryptionAlgId).toString();
            if (algorithm.toUpperCase().indexOf("CBC") != -1) {
                byte[] iv = null;
                CBCParam cbcParam = new CBCParam();
                iv = doct.getOctets();
                cbcParam.setIv(iv);
                if (algorithm.equals("DES/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DES/CBC/PKCS7Padding", cbcParam);
                } else if (algorithm.equals("DESede/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                }
            } else if (algorithm.toUpperCase().indexOf("PBE") != -1) {
                ASN1Sequence seq = (ASN1Sequence)alg.getParameters();
                if (seq == null) {
                    throw new PKIException("850617", "\u4ea7\u751fPKCS7\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e2d\u7684PBE\u53c2\u6570\u4e3a\u7a7a");
                }
                byte[] salt = ((ASN1OctetString)seq.getObjectAt(0)).getOctets();
                int iterations = ((DERInteger)seq.getObjectAt(1)).getValue().intValue();
                PBEParam pbeParam = null;
                pbeParam.setIterations(iterations);
                pbeParam.setSalt(salt);
                if (algorithm.equals("PBEWithMD5AndDES")) {
                    mechanism = new Mechanism("PBEWithMD5AndDES", pbeParam);
                } else if (algorithm.equals("PBEWithSHA1AndDES")) {
                    mechanism = new Mechanism("PBEWithSHA1AndDES", pbeParam);
                } else if (algorithm.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC")) {
                    mechanism = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", pbeParam);
                } else if (algorithm.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC")) {
                    mechanism = new Mechanism("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", pbeParam);
                }
            } else {
                mechanism = new Mechanism(algorithm);
            }
            return this.session.decrypt(mechanism, jkey, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("850618", "\u89e3\u6790\u52a0\u5bc6\u6570\u636e\u5305\u5931\u8d25", ex);
        }
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism mechanism = new Mechanism("DES/CBC/PKCS7Padding", new CBCParam());
            PKCS7EncryptedData p7EncData = new PKCS7EncryptedData(session);
            PKCS12 p12 = new PKCS12();
            p12.load("C:/ccb.pfx");
            p12.decrypt("111".toCharArray());
            Pfx pfx = p12.getPfx();
            JKey key = session.generateKey(new Mechanism("DES"), 64);
            EncryptedContentInfo test = p7EncData.generateEncryptedContentInfo(DATA, mechanism, "abcd".getBytes(), key);
            System.out.println("generateEncryptedContentInfo OK.");
            byte[] souceData = p7EncData.getContent(test, key);
            System.out.println(new String(souceData));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

