/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.BERSet;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EncryptedContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EnvelopedData;
import com.cfca.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.pkcs.pkcs7.RecipientInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7EncryptedData;
import com.cfca.util.pki.pkcs.PKCS7SignedData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class PKCS7EnvelopedData {
    private Session session = null;
    private EnvelopedData envelopedData = null;
    private List recipientCerts = new ArrayList();
    public static Hashtable MECH_OID = new Hashtable();
    public static Hashtable OID_MECH = new Hashtable();

    public PKCS7EnvelopedData(Session session) {
        this.session = session;
    }

    public void addRecipient(X509Cert recipientCert) throws PKIException {
        this.recipientCerts.add(recipientCert);
    }

    public byte[] generateEnvelopedData(String contentType, byte[] content, Mechanism contentEncryptionAlg) throws PKIException {
        if (contentType == null) {
            contentType = PKCS7SignedData.DATA;
        }
        if (this.recipientCerts.size() == 0) {
            throw new PKIException("850619", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u63a5\u6536\u8005\u8bc1\u4e66\u4e3a\u7a7a");
        }
        DERObjectIdentifier tOID = (DERObjectIdentifier)MECH_OID.get(contentEncryptionAlg.getMechanismType());
        AlgorithmIdentifier contentEncryptAlg = this.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        JKey sessionKey = this.getSessionKey(contentEncryptionAlg);
        if (sessionKey == null) {
            throw new PKIException("850620", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u4ea7\u751f\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25");
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        for (int i = 0; i < this.recipientCerts.size(); ++i) {
            X509Cert recipientCert = (X509Cert)this.recipientCerts.get(i);
            BigInteger sn = recipientCert.getSerialNumber();
            String issuer = recipientCert.getIssuer();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
            AlgorithmIdentifier KeyEncryptionAlg = null;
            if (recipientCert.getSignatureAlgName().indexOf("RSA") == -1) {
                throw new PKIException("850621", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301");
            }
            KeyEncryptionAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
            JKey pubKey = recipientCert.getPublicKey();
            byte[] encryptedKey = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), pubKey, sessionKey.getKey());
            RecipientInfo recipientInfo = new RecipientInfo(new DERInteger(0), issuerAndSn, KeyEncryptionAlg, new DEROctetString(encryptedKey));
            derV.add(recipientInfo);
        }
        BERSet recipientInfos = new BERSet(derV);
        byte[] encryptedContent = this.session.encrypt(contentEncryptionAlg, sessionKey, content);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier(contentType), contentEncryptAlg, new DEROctetString(encryptedContent));
        EnvelopedData envelopedData = new EnvelopedData(new DERInteger(0), recipientInfos, encryptedContentInfo);
        return Parser.writeDERObj2Bytes(envelopedData);
    }

    public byte[] generateEnvelopedData(String contentType, byte[] content, Mechanism contentEncryptionAlg, X509Cert recipientCert) throws PKIException {
        if (contentType == null) {
            contentType = PKCS7SignedData.DATA;
        }
        if (recipientCert == null) {
            throw new PKIException("850619", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u63a5\u6536\u8005\u8bc1\u4e66\u4e3a\u7a7a");
        }
        BigInteger sn = recipientCert.getSerialNumber();
        String issuer = recipientCert.getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        DERObjectIdentifier tOID = (DERObjectIdentifier)MECH_OID.get(contentEncryptionAlg.getMechanismType());
        AlgorithmIdentifier contentEncryptAlg = this.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        JKey sessionKey = this.getSessionKey(contentEncryptionAlg);
        if (sessionKey == null) {
            throw new PKIException("850620", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u4ea7\u751f\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25");
        }
        AlgorithmIdentifier KeyEncryptionAlg = null;
        if (recipientCert.getSignatureAlgName().indexOf("RSA") == -1) {
            throw new PKIException("850621", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        KeyEncryptionAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        JKey pubKey = recipientCert.getPublicKey();
        byte[] encryptedKey = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), pubKey, sessionKey.getKey());
        RecipientInfo recipientInfo = new RecipientInfo(new DERInteger(0), issuerAndSn, KeyEncryptionAlg, new DEROctetString(encryptedKey));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(recipientInfo);
        BERSet recipientInfos = new BERSet(derV);
        byte[] encryptedContent = this.session.encrypt(contentEncryptionAlg, sessionKey, content);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier(contentType), contentEncryptAlg, new DEROctetString(encryptedContent));
        EnvelopedData envelopedData = new EnvelopedData(new DERInteger(0), recipientInfos, encryptedContentInfo);
        return Parser.writeDERObj2Bytes(envelopedData);
    }

    public byte[] generateEnvelopedDataContent(byte[] content) throws PKIException {
        EnvelopedData envelopedData = EnvelopedData.getInstance(Parser.writeBytes2DERObj(content));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, envelopedData);
        return Parser.writeDERObj2Bytes(contentInfo);
    }

    public byte[] generateCryptoAPISignAndEnvContent(byte[] content) throws PKIException {
        EnvelopedData envelopedData = EnvelopedData.getInstance(Parser.writeBytes2DERObj(content));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, envelopedData);
        return Parser.writeDERObj2Bytes(contentInfo);
    }

    public byte[] generateSignAndEnvDataExtendCryptAPI(String contentType, byte[] content, Mechanism contentEncryptionAlg, JKey signerPriKey, X509Cert signerCert, X509Cert recipientCert) throws PKIException {
        if (recipientCert == null) {
            throw new PKIException("850643", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u63a5\u6536\u8005\u8bc1\u4e66\u4e3a\u7a7a");
        }
        X509Certificate javaSignerCert = null;
        PrivateKey javaSignerPriKey = null;
        javaSignerPriKey = Parser.convertPrivateKey(signerPriKey);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(signerCert.getEncoded());
            javaSignerCert = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (Exception ex) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        ArrayList<X509Certificate> collection = new ArrayList<X509Certificate>();
        collection.add(javaSignerCert);
        CollectionCertStoreParameters certStorePara = new CollectionCertStoreParameters(collection);
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)certStorePara, "BC");
        }
        catch (NoSuchProviderException ex1) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex1);
        }
        catch (NoSuchAlgorithmException ex1) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex1);
        }
        catch (InvalidAlgorithmParameterException ex1) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex1);
        }
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addSigner(javaSignerPriKey, javaSignerCert, CMSSignedDataGenerator.DIGEST_SHA1);
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CMSException ex2) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", (Exception)((Object)ex2));
        }
        catch (CertStoreException ex2) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex2);
        }
        CMSProcessableByteArray cmsContent = null;
        cmsContent = new CMSProcessableByteArray(content);
        CMSSignedData signedData = null;
        try {
            signedData = gen.generate((CMSProcessable)cmsContent, true, "BC");
        }
        catch (CMSException ex3) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", (Exception)((Object)ex3));
        }
        catch (NoSuchProviderException ex3) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex3);
        }
        catch (NoSuchAlgorithmException ex3) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex3);
        }
        byte[] cmsSignData = null;
        try {
            cmsSignData = signedData.getEncoded();
        }
        catch (IOException ex4) {
            throw new PKIException("850642", "\u4ea7\u751fCrypto API\u5f62\u5f0f\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex4);
        }
        BigInteger sn = recipientCert.getSerialNumber();
        String issuer = recipientCert.getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        DERObjectIdentifier tOID = (DERObjectIdentifier)MECH_OID.get(contentEncryptionAlg.getMechanismType());
        AlgorithmIdentifier contentEncryptAlg = this.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        JKey sessionKey = this.getSessionKey(contentEncryptionAlg);
        if (sessionKey == null) {
            throw new PKIException("850620", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u4ea7\u751f\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25");
        }
        AlgorithmIdentifier KeyEncryptionAlg = null;
        if (recipientCert.getSignatureAlgName().indexOf("RSA") == -1) {
            throw new PKIException("850621", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        KeyEncryptionAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        JKey pubKey = recipientCert.getPublicKey();
        byte[] encryptedKey = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), pubKey, sessionKey.getKey());
        RecipientInfo recipientInfo = new RecipientInfo(new DERInteger(0), issuerAndSn, KeyEncryptionAlg, new DEROctetString(encryptedKey));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(recipientInfo);
        BERSet recipientInfos = new BERSet(derV);
        byte[] encryptedContent = this.session.encrypt(contentEncryptionAlg, sessionKey, cmsSignData);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier(contentType), contentEncryptAlg, new DEROctetString(encryptedContent));
        EnvelopedData envelopedData = new EnvelopedData(new DERInteger(0), recipientInfos, encryptedContentInfo);
        return Parser.writeDERObj2Bytes(envelopedData);
    }

    public byte[] getEnvelopedDataFromContentInfo(byte[] bContentInfo) throws PKIException {
        DERObject derObj = Parser.writeBytes2DERObj(bContentInfo);
        ContentInfo contentInfo = ContentInfo.getInstance(derObj);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.envelopedData)) {
            throw new PKIException("850632", "\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u6570\u5b57\u4fe1\u5c01");
        }
        EnvelopedData envelopedData = EnvelopedData.getInstance(contentInfo.getContent());
        return Parser.writeDERObj2Bytes(envelopedData);
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(Mechanism contentEncryptionAlg, DERObjectIdentifier tOID) throws PKIException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(tOID, new DERNull());
        try {
            if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
                Object param = contentEncryptionAlg.getParam();
                if (param == null) {
                    throw new PKIException("850622", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0cCBC\u53c2\u6570\u4e3a\u7a7a");
                }
                CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
                DEROctetString doct = new DEROctetString(cbcParam.getIv());
                algorithmIdentifier = new AlgorithmIdentifier(tOID, doct);
                return algorithmIdentifier;
            }
            return algorithmIdentifier;
        }
        catch (Exception ex) {
            throw new PKIException("850623", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
    }

    private JKey getSessionKey(Mechanism contentEncryptionAlg) throws PKIException {
        JKey sessionKey = null;
        try {
            if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
                if (cbcParam == null) {
                    throw new PKIException("850622", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0cCBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                if (contentEncryptionAlg.getMechanismType().equals("DES/CBC/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("DES"), 64);
                } else if (contentEncryptionAlg.getMechanismType().equals("DESede/CBC/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("DESede"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("RC2/CBC/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("RC2"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("IDEA/CBC/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("IDEA"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("AES/CBC/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("AES"), 128);
                }
            } else if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("ECB") != -1) {
                if (contentEncryptionAlg.getMechanismType().equals("DES/ECB/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("DES"), 64);
                } else if (contentEncryptionAlg.getMechanismType().equals("DESede/ECB/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("DESede"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("RC2/ECB/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("RC2"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("IDEA/ECB/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("IDEA"), 128);
                } else if (contentEncryptionAlg.getMechanismType().equals("AES/ECB/PKCS7Padding")) {
                    sessionKey = this.session.generateKey(new Mechanism("AES"), 128);
                }
            } else if (contentEncryptionAlg.getMechanismType().toUpperCase().equals("RC4")) {
                sessionKey = this.session.generateKey(new Mechanism("RC4"), 128);
            }
        }
        catch (Exception ex) {
            throw new PKIException("850620", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u4ea7\u751f\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25", ex);
        }
        return sessionKey;
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.load(data);
    }

    public void loadDer(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void loadBase64(byte[] data) throws PKIException {
        byte[] tmpData = Parser.convertBase64(data);
        tmpData = Base64.decode(tmpData);
        ByteArrayInputStream bis = new ByteArrayInputStream(tmpData);
        this.load(bis);
    }

    public void loadDer(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.loadDer(data);
    }

    public void loadBase64(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.loadBase64(data);
    }

    public void load(EnvelopedData envelopedData) throws PKIException {
        this.envelopedData = envelopedData;
    }

    private void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        EnvelopedData tEnvelopedData = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            tEnvelopedData = EnvelopedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.envelopedData = tEnvelopedData;
    }

    public byte[] getContent(X509Cert recipientCert, JKey recipientPriKey) throws PKIException {
        try {
            byte[] decryptedData = null;
            EncryptedContentInfo encryptedContentInfo = this.envelopedData.getEncryptedContentInfo();
            if (encryptedContentInfo == null) {
                throw new PKIException("850625", "\u5f85\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e3a\u7a7a");
            }
            byte[] encryptedData = null;
            if (encryptedContentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
                if (encryptedContentInfo.getEncryptedContent() == null) {
                    throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", new Exception("no sourceData to be verify."));
                }
                encryptedData = encryptedContentInfo.getEncryptedContent().getOctets();
            } else {
                encryptedData = Parser.writeDERObj2Bytes(encryptedContentInfo.getEncryptedContent().getDERObject());
            }
            ASN1Set asn1Set = this.envelopedData.getRecipientInfos();
            boolean hasRecipent = false;
            for (int i = 0; i < asn1Set.size(); ++i) {
                IssuerAndSerialNumber actualIssuerAndSN;
                BigInteger sn;
                RecipientInfo recipientInfo = RecipientInfo.getInstance(this.envelopedData.getRecipientInfos().getObjectAt(i));
                String issuer = recipientCert.getIssuer();
                IssuerAndSerialNumber userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn = recipientCert.getSerialNumber());
                if (!userIssuerAndSN.equals(actualIssuerAndSN = recipientInfo.getIssuerAndSerialNumber())) continue;
                hasRecipent = true;
                byte[] encryptedKey = recipientInfo.getEncryptedKey().getOctets();
                AlgorithmIdentifier alg = encryptedContentInfo.getContentEncryptionAlgorithm();
                DERObjectIdentifier encryptionAlgId = alg.getObjectId();
                byte[] decryptedKey = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), recipientPriKey, encryptedKey);
                JKey sessionKey = null;
                Mechanism mechanism = null;
                String encryptionAlgStr = (String)OID_MECH.get(encryptionAlgId);
                if (encryptionAlgStr.indexOf("CBC") != -1) {
                    DEROctetString doct = (DEROctetString)alg.getParameters();
                    byte[] iv = null;
                    CBCParam cbcParam = new CBCParam();
                    iv = doct.getOctets();
                    cbcParam.setIv(iv);
                    if (encryptionAlgStr.equals("DES/CBC/PKCS7Padding")) {
                        mechanism = new Mechanism("DES/CBC/PKCS7Padding", cbcParam);
                        sessionKey = new JKey("DES", decryptedKey);
                    } else if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                        mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                        sessionKey = new JKey("DESede", decryptedKey);
                    }
                } else if (encryptionAlgStr.indexOf("ECB") != -1) {
                    if (encryptionAlgStr.equals("DES/ECB/PKCS7Padding")) {
                        mechanism = new Mechanism("DES/ECB/PKCS7Padding");
                        sessionKey = new JKey("DES", decryptedKey);
                    } else if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                        mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                        sessionKey = new JKey("DESede", decryptedKey);
                    }
                } else if (encryptionAlgStr.equals("RC4")) {
                    mechanism = new Mechanism("RC4");
                    sessionKey = this.session instanceof JSoftLib ? new JKey("RC4", decryptedKey) : new JKey("RC4_KEY", decryptedKey);
                } else {
                    throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
                }
                decryptedData = this.session.decrypt(mechanism, sessionKey, encryptedData);
            }
            if (!hasRecipent) {
                throw new PKIException("850634", "\u4f7f\u7528\u7684\u79c1\u94a5\u8bc1\u4e66\u548c\u5c01\u88c5\u6570\u5b57\u4fe1\u5c01\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
            }
            return decryptedData;
        }
        catch (Exception ex) {
            throw new PKIException("850624", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
    }

    public byte[] getContentExtendCryptoAPI(JKey recipientPriKey) throws PKIException {
        return this.getContentExtendCryptoAPI(null, recipientPriKey);
    }

    public byte[] getContentExtendCryptoAPI(X509Cert recipientCert, JKey recipientPriKey) throws PKIException {
        try {
            IssuerAndSerialNumber actualIssuerAndSN;
            BigInteger sn;
            String issuer;
            IssuerAndSerialNumber userIssuerAndSN;
            EncryptedContentInfo encryptedContentInfo = this.envelopedData.getEncryptedContentInfo();
            if (encryptedContentInfo == null) {
                throw new PKIException("850638", "\u5f85\u89e3\u6790\u7684Crypto API\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e2d,\u52a0\u5bc6\u4fe1\u606f\u4e3a\u7a7a");
            }
            byte[] encryptedData = null;
            if (encryptedContentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
                if (encryptedContentInfo.getEncryptedContent() == null) {
                    throw new PKIException("850637", "\u89e3\u6790Crypto API\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", new Exception("no sourceData to be verify."));
                }
                encryptedData = encryptedContentInfo.getEncryptedContent().getOctets();
            } else {
                encryptedData = Parser.writeDERObj2Bytes(encryptedContentInfo.getEncryptedContent().getDERObject());
            }
            RecipientInfo recipientInfo = RecipientInfo.getInstance(this.envelopedData.getRecipientInfos().getObjectAt(0));
            byte[] encryptedKey = recipientInfo.getEncryptedKey().getOctets();
            if (recipientCert != null && !(userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer = recipientCert.getIssuer()), sn = recipientCert.getSerialNumber())).equals(actualIssuerAndSN = recipientInfo.getIssuerAndSerialNumber())) {
                throw new PKIException("850639", "\u5f85\u89e3\u6790\u7684Crypto API\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e2d,\u63a5\u6536\u8005\u8bc1\u4e66\u4e0d\u5339\u914d");
            }
            AlgorithmIdentifier alg = encryptedContentInfo.getContentEncryptionAlgorithm();
            DERObjectIdentifier encryptionAlgId = alg.getObjectId();
            byte[] decryptedKey = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), recipientPriKey, encryptedKey);
            JKey sessionKey = null;
            Mechanism mechanism = null;
            String encryptionAlgStr = (String)OID_MECH.get(encryptionAlgId);
            if (encryptionAlgStr.indexOf("CBC") != -1) {
                DEROctetString doct = (DEROctetString)alg.getParameters();
                byte[] iv = null;
                CBCParam cbcParam = new CBCParam();
                iv = doct.getOctets();
                cbcParam.setIv(iv);
                if (encryptionAlgStr.equals("DES/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DES/CBC/PKCS7Padding", cbcParam);
                    sessionKey = new JKey("DES", decryptedKey);
                } else if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                    sessionKey = new JKey("DESede", decryptedKey);
                }
            } else if (encryptionAlgStr.indexOf("ECB") != -1) {
                if (encryptionAlgStr.equals("DES/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("DES/ECB/PKCS7Padding");
                    sessionKey = new JKey("DES", decryptedKey);
                } else if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                    sessionKey = this.session instanceof JSoftLib ? new JKey("RC4", decryptedKey) : new JKey("RC4_KEY", decryptedKey);
                }
            } else if (encryptionAlgStr.equals("RC4")) {
                mechanism = new Mechanism("RC4");
                sessionKey = new JKey("RC4", decryptedKey);
            } else {
                throw new PKIException("850640", "\u89e3\u6790\u7684Crypto API\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
            }
            byte[] decryptedData = this.session.decrypt(mechanism, sessionKey, encryptedData);
            CMSSignedData signedData = new CMSSignedData(decryptedData);
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersInfo = signedData.getSignerInfos();
            Collection signers = signersInfo.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signerInfo = (SignerInformation)it.next();
                if (signerInfo.verify(cert = (X509Certificate)(certIt = (certCollection = certs.getCertificates((CertSelector)signerInfo.getSID())).iterator()).next(), "BC")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    CMSProcessable cms = signedData.getSignedContent();
                    cms.write((OutputStream)bos);
                    return bos.toByteArray();
                }
                throw new PKIException("850641", "850641");
            }
            return decryptedData;
        }
        catch (Exception ex) {
            throw new PKIException("850637", "\u89e3\u6790Crypto API\u7684\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism mechanism = new Mechanism("DES/CBC/PKCS7Padding", new CBCParam());
            PKCS7EnvelopedData p7EnvelopedData = new PKCS7EnvelopedData(session);
            PKCS12 p12Receive = new PKCS12();
            p12Receive.load("d:/temp/ZZW.pfx");
            p12Receive.decrypt("11111111".toCharArray());
            JKey revPrvKey = p12Receive.getPrivateKey();
            X509Cert[] receiveCerts = p12Receive.getCerts();
            X509Cert receiveCert = receiveCerts[0];
            PKCS12 p12Receive2 = new PKCS12();
            p12Receive2.load("d:/temp/userCert.pfx");
            p12Receive2.decrypt("111".toCharArray());
            JKey revPrvKey2 = p12Receive2.getPrivateKey();
            X509Cert receiveCert2 = p12Receive2.getCertificate();
            byte[] src = "\u6570\u5b57\u4fe1\u5c01\u6d4b\u8bd5".getBytes("UTF-16LE");
            p7EnvelopedData.addRecipient(receiveCert);
            p7EnvelopedData.addRecipient(receiveCert2);
            byte[] envelopedData = p7EnvelopedData.generateEnvelopedData(PKCS7EncryptedData.DATA, src, mechanism);
            envelopedData = p7EnvelopedData.generateEnvelopedDataContent(envelopedData);
            p7EnvelopedData.load(envelopedData);
            byte[] data = p7EnvelopedData.getContent(receiveCert, revPrvKey);
            System.out.println("\u7b2c\u4e00\u4e2a\u63a5\u6536\u8005\uff1a" + new String(data, "UTF-16LE"));
            data = p7EnvelopedData.getContent(receiveCert2, revPrvKey2);
            System.out.println("\u7b2c\u4e8c\u4e2a\u63a5\u6536\u8005\uff1a" + new String(data, "UTF-16LE"));
            System.out.println("OK!");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    static {
        MECH_OID.put("DES/CBC/PKCS7Padding", PKCSObjectIdentifiers.desCBCEncryption);
        MECH_OID.put("DES/ECB/PKCS7Padding", PKCSObjectIdentifiers.desEncryption);
        MECH_OID.put("DESede/CBC/PKCS7Padding", PKCSObjectIdentifiers.des3CBCEncryption);
        MECH_OID.put("DESede/ECB/PKCS7Padding", PKCSObjectIdentifiers.des3Encryption);
        MECH_OID.put("RSA/ECB/PKCS1PADDING", PKCSObjectIdentifiers.rsaEncryption);
        MECH_OID.put("RC2/CBC/PKCS7Padding", PKCSObjectIdentifiers.rc2CBCEncryption);
        MECH_OID.put("RC2/ECB/PKCS7Padding", PKCSObjectIdentifiers.rc2Encryption);
        MECH_OID.put("RC4", PKCSObjectIdentifiers.rc4Encryption);
        MECH_OID.put("PBEWithMD5AndDES", PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        MECH_OID.put("PBEWithSHA1AndDES", PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        MECH_OID.put("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd2DESCBC);
        MECH_OID.put("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC);
        OID_MECH.put(PKCSObjectIdentifiers.desCBCEncryption, "DES/CBC/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.desEncryption, "DES/ECB/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.des3CBCEncryption, "DESede/CBC/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.des3Encryption, "DESede/ECB/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.rsaEncryption, "RSA/ECB/PKCS1PADDING");
        OID_MECH.put(PKCSObjectIdentifiers.rc2CBCEncryption, "RC2/CBC/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.rc2Encryption, "RC2/ECB/PKCS7Padding");
        OID_MECH.put(PKCSObjectIdentifiers.rc4Encryption, "RC4");
        OID_MECH.put(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWithMD5AndDES");
        OID_MECH.put(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWithSHA1AndDES");
        OID_MECH.put(PKCSObjectIdentifiers.pbeWithSHAAnd2DESCBC, "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        OID_MECH.put(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC, "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
    }
}

