/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.BERSet;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs12.Pfx;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EncryptedContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.pkcs.pkcs7.RecipientInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignedAndEnvelopedData;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignerInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7EncryptedData;
import com.cfca.util.pki.pkcs.PKCS7EnvelopedData;
import com.cfca.util.pki.pkcs.PKCS7SignedData;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class PKCS7SignEnvData {
    private Session session = null;
    private PKCS7EncryptedData encryptedData = null;
    private Mechanism contentEncryptMechanism = null;
    private SignedAndEnvelopedData signedAndEnvelopedData = null;

    public PKCS7SignEnvData(Session session) {
        this.session = session;
        this.encryptedData = new PKCS7EncryptedData(session);
    }

    public byte[] generateSigAndEnvelop(String contentType, byte[] content, Mechanism contentEncryptMechanism, X509Cert recipientCert, Pfx signaturePfx, char[] pfxPwd) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(signaturePfx);
        p12.decrypt(pfxPwd);
        JKey singnatureKey = p12.getPrivateKey();
        X509Cert singnatureCert = p12.getCertificate();
        return this.generateSigAndEnvelop(contentType, content, contentEncryptMechanism, recipientCert, singnatureCert, singnatureKey);
    }

    public byte[] generateSigAndEnvelop(String contentType, byte[] content, Mechanism contentEncryptMechanism, X509Cert recipientCert, X509Cert singerCert, JKey singnatureKey) throws PKIException {
        if (recipientCert == null) {
            throw new PKIException("850626", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        if (singerCert == null) {
            throw new PKIException("850626", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        JKey contentEncryptKey = null;
        this.contentEncryptMechanism = contentEncryptMechanism;
        String contentEncryptMech = contentEncryptMechanism.getMechanismType();
        if (contentEncryptMech.toUpperCase().indexOf("DESEDE") != -1) {
            contentEncryptKey = this.session.generateKey(new Mechanism("DESede"), 192);
        } else if (contentEncryptMech.toUpperCase().indexOf("DES") != -1) {
            contentEncryptKey = this.session.generateKey(new Mechanism("DES"), 64);
        } else if (contentEncryptMech.toUpperCase().indexOf("RC4") != -1) {
            contentEncryptKey = this.session instanceof JSoftLib ? this.session.generateKey(new Mechanism("RC4"), 128) : this.session.generateKey(new Mechanism("RC4_KEY"), 128);
        } else {
            throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        EncryptedContentInfo encryptedContenInfo = this.encryptedData.generateEncryptedContentInfo(contentType, contentEncryptMechanism, content, contentEncryptKey);
        JKey recipientKey = recipientCert.getPublicKey();
        BigInteger recipientSN = recipientCert.getSerialNumber();
        String recipientIssuer = recipientCert.getIssuer();
        IssuerAndSerialNumber recipientIssuerAndSN = new IssuerAndSerialNumber(new X509Name(recipientIssuer), recipientSN);
        AlgorithmIdentifier keyEncryptionAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        RecipientInfo recipientInfo = this.generateRecipientInfo(recipientIssuerAndSN, keyEncryptionAlg, contentEncryptKey.getKey(), recipientKey);
        BigInteger signerSN = singerCert.getSerialNumber();
        String signerIssuer = singerCert.getIssuer();
        IssuerAndSerialNumber signerIssuerAndSN = new IssuerAndSerialNumber(new X509Name(signerIssuer), signerSN);
        Mechanism sinMechanism = new Mechanism("SHA1withRSAEncryption");
        SignerInfo signerInfo = this.generateSignerInfo(content, signerIssuerAndSN, sinMechanism, contentEncryptMechanism, singnatureKey, contentEncryptKey);
        DERInteger version = new DERInteger(1);
        DERSet recipientInfos = new DERSet(recipientInfo.getDERObject());
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1);
        DERSet digestAlgs = new DERSet(digestAlg.getDERObject());
        DERSet signerInfos = new DERSet(signerInfo.getDERObject());
        ASN1EncodableVector v = new ASN1EncodableVector();
        X509CertificateStructure certStruc = singerCert.getCertStructure();
        v.add(certStruc);
        BERSet setCert = new BERSet(v);
        SignedAndEnvelopedData sigAndEnvelop = new SignedAndEnvelopedData(version, recipientInfos, digestAlgs, encryptedContenInfo, setCert, null, signerInfos);
        return Parser.writeDERObj2Bytes(sigAndEnvelop);
    }

    public byte[] generateSigAndEnvelopExtendC(String contentType, byte[] content, Mechanism contentEncryptMechanism, X509Cert recipientCert, Pfx signaturePfx, char[] pfxPwd) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(signaturePfx);
        p12.decrypt(pfxPwd);
        JKey singnatureKey = p12.getPrivateKey();
        return this.generateSigAndEnvelopExtendC(contentType, content, contentEncryptMechanism, recipientCert, p12.getCertificate(), singnatureKey);
    }

    public byte[] generateSigAndEnvelopExtendC(String contentType, byte[] content, Mechanism contentEncryptMechanism, X509Cert recipientCert, X509Cert singerCert, JKey singnatureKey) throws PKIException {
        if (recipientCert == null) {
            throw new PKIException("850626", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        if (singerCert == null) {
            throw new PKIException("850626", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        JKey contentEncryptKey = null;
        this.contentEncryptMechanism = contentEncryptMechanism;
        String contentEncryptMech = contentEncryptMechanism.getMechanismType();
        if (contentEncryptMech.toUpperCase().indexOf("DESEDE") != -1) {
            contentEncryptKey = this.session.generateKey(new Mechanism("DESede"), 192);
        } else if (contentEncryptMech.toUpperCase().indexOf("DES") != -1) {
            contentEncryptKey = this.session.generateKey(new Mechanism("DES"), 64);
        } else if (contentEncryptMech.toUpperCase().indexOf("RC4") != -1) {
            contentEncryptKey = this.session instanceof JSoftLib ? this.session.generateKey(new Mechanism("RC4"), 128) : this.session.generateKey(new Mechanism("RC4_KEY"), 128);
        } else {
            throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        EncryptedContentInfo encryptedContenInfo = this.encryptedData.generateEncryptedContentInfo(contentType, contentEncryptMechanism, content, contentEncryptKey);
        JKey recipientKey = recipientCert.getPublicKey();
        BigInteger recipientSN = recipientCert.getSerialNumber();
        String recipientIssuer = recipientCert.getIssuer();
        IssuerAndSerialNumber recipientIssuerAndSN = new IssuerAndSerialNumber(new X509Name(recipientIssuer), recipientSN);
        AlgorithmIdentifier keyEncryptionAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        RecipientInfo recipientInfo = this.generateRecipientInfo(recipientIssuerAndSN, keyEncryptionAlg, contentEncryptKey.getKey(), recipientKey);
        BigInteger signerSN = singerCert.getSerialNumber();
        String signerIssuer = singerCert.getIssuer();
        IssuerAndSerialNumber signerIssuerAndSN = new IssuerAndSerialNumber(new X509Name(signerIssuer), signerSN);
        Mechanism sinMechanism = new Mechanism("SHA1withRSAEncryption");
        SignerInfo signerInfo = this.generateSignerInfoExtendC(content, signerIssuerAndSN, sinMechanism, contentEncryptMechanism, singnatureKey, contentEncryptKey);
        DERInteger version = new DERInteger(1);
        DERSet recipientInfos = new DERSet(recipientInfo.getDERObject());
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1);
        DERSet digestAlgs = new DERSet(digestAlg.getDERObject());
        DERSet signerInfos = new DERSet(signerInfo.getDERObject());
        ASN1EncodableVector v = new ASN1EncodableVector();
        X509CertificateStructure certStruc = singerCert.getCertStructure();
        v.add(certStruc);
        BERSet setCert = new BERSet(v);
        SignedAndEnvelopedData sigAndEnvelop = new SignedAndEnvelopedData(version, recipientInfos, digestAlgs, encryptedContenInfo, setCert, null, signerInfos);
        return Parser.writeDERObj2Bytes(sigAndEnvelop);
    }

    public byte[] generateSignedAndEnvelopedDataContent(byte[] content) throws PKIException {
        SignedAndEnvelopedData signedAndEnvelopedData = SignedAndEnvelopedData.getInstance(Parser.writeBytes2DERObj(content));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, signedAndEnvelopedData);
        return Parser.writeDERObj2Bytes(contentInfo);
    }

    public byte[] getSignEnvDataFromContentInfo(byte[] bContentInfo) throws PKIException {
        DERObject derObj = Parser.writeBytes2DERObj(bContentInfo);
        ContentInfo contentInfo = ContentInfo.getInstance(derObj);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedAndEnvelopedData)) {
            throw new PKIException("850633", "\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01");
        }
        SignedAndEnvelopedData signedEnvData = SignedAndEnvelopedData.getInstance(contentInfo.getContent());
        return Parser.writeDERObj2Bytes(signedEnvData);
    }

    private RecipientInfo generateRecipientInfo(IssuerAndSerialNumber recipientIssuerAndSN, AlgorithmIdentifier keyEncryptionAlg, byte[] contentEncryptKey, JKey jRecipientPubKey) throws PKIException {
        byte[] encryptedKey = null;
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        encryptedKey = this.session.encrypt(mechanism, jRecipientPubKey, contentEncryptKey);
        DEROctetString derEncryptedKey = new DEROctetString(encryptedKey);
        RecipientInfo recipientInfo = new RecipientInfo(new DERInteger(0), recipientIssuerAndSN, keyEncryptionAlg, derEncryptedKey);
        return recipientInfo;
    }

    private SignerInfo generateSignerInfo(byte[] contentInfo, IssuerAndSerialNumber issuerAndSerialNumber, Mechanism singnatureAlg, Mechanism doublyEncryptionAlg, JKey jSingnatureKey, JKey jDoublyEncryptionKey) throws PKIException {
        byte[] signature = this.session.sign(singnatureAlg, jSingnatureKey, contentInfo);
        byte[] doublyEncryptionDigest = this.doublyEncryption(signature, doublyEncryptionAlg, jDoublyEncryptionKey);
        DERInteger version = new DERInteger(1);
        DEROctetString octetDoublyEncryption = new DEROctetString(doublyEncryptionDigest);
        if (issuerAndSerialNumber == null) {
            throw new PKIException("850628", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        DERObjectIdentifier contentEncryptOID = (DERObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(this.contentEncryptMechanism.getMechanismType());
        AlgorithmIdentifier digestEncryptionAlg = new AlgorithmIdentifier(contentEncryptOID);
        Object param = doublyEncryptionAlg.getParam();
        if (param != null) {
            CBCParam cbcParam = (CBCParam)param;
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            digestEncryptionAlg = new AlgorithmIdentifier(contentEncryptOID, doct);
        }
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1);
        SignerInfo signerInfo = new SignerInfo(version, issuerAndSerialNumber, digestAlg, null, digestEncryptionAlg, octetDoublyEncryption, null);
        return signerInfo;
    }

    private SignerInfo generateSignerInfoExtendC(byte[] contentInfo, IssuerAndSerialNumber issuerAndSerialNumber, Mechanism singnatureAlg, Mechanism doublyEncryptionAlg, JKey jSingnatureKey, JKey jDoublyEncryptionKey) throws PKIException {
        byte[] encryptionDigestData = this.doublyEncryption(contentInfo, doublyEncryptionAlg, jDoublyEncryptionKey);
        byte[] signature = this.session.sign(singnatureAlg, jSingnatureKey, encryptionDigestData);
        DERInteger version = new DERInteger(1);
        DEROctetString octetDoublyEncryption = new DEROctetString(signature);
        if (issuerAndSerialNumber == null) {
            throw new PKIException("850628", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        DERObjectIdentifier contentEncryptOID = (DERObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(this.contentEncryptMechanism.getMechanismType());
        AlgorithmIdentifier digestEncryptionAlg = new AlgorithmIdentifier(contentEncryptOID);
        Object param = doublyEncryptionAlg.getParam();
        if (param != null) {
            CBCParam cbcParam = (CBCParam)param;
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            digestEncryptionAlg = new AlgorithmIdentifier(contentEncryptOID, doct);
        }
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1);
        SignerInfo signerInfo = new SignerInfo(version, issuerAndSerialNumber, digestAlg, null, digestEncryptionAlg, octetDoublyEncryption, null);
        return signerInfo;
    }

    private byte[] doublyEncryption(byte[] signature, Mechanism doublyEncryptionAlg, JKey doublyEncryptionKey) throws PKIException {
        byte[] doublyEncryptionDigest = null;
        doublyEncryptionDigest = this.session.encrypt(doublyEncryptionAlg, doublyEncryptionKey, signature);
        return doublyEncryptionDigest;
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedAndEnvelopedData tSignedAndEnvelopedData = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            tSignedAndEnvelopedData = SignedAndEnvelopedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.signedAndEnvelopedData = tSignedAndEnvelopedData;
    }

    public void load(SignedAndEnvelopedData signedAndEnvelopedData) throws PKIException {
        this.signedAndEnvelopedData = signedAndEnvelopedData;
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
        }
        this.load(data);
    }

    public byte[] getContent(Pfx recipientPfx, char[] pfxPwd, X509Cert signerCert) throws PKIException {
        PKCS12 p12Parser = new PKCS12();
        p12Parser.load(recipientPfx);
        p12Parser.decrypt(pfxPwd);
        JKey recipientPriKey = p12Parser.getPrivateKey();
        X509Cert recipientCert = p12Parser.getCertificate();
        return this.getContent(recipientCert, recipientPriKey, signerCert);
    }

    public byte[] getContent(X509Cert recipientCert, JKey recipientPriKey, X509Cert signerCert) throws PKIException {
        IssuerAndSerialNumber actualIssuerAndSN;
        BigInteger sn;
        if (this.signedAndEnvelopedData == null) {
            throw new PKIException("850630", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e3a\u7a7a");
        }
        if (signerCert == null) {
            throw new PKIException("850626", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        if (recipientCert == null) {
            throw new PKIException("850626", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        EncryptedContentInfo encryptedContentInfo = this.signedAndEnvelopedData.getEncryptedContentInfo();
        RecipientInfo recipientInfo = RecipientInfo.getInstance(this.signedAndEnvelopedData.getRecipientInfos().getObjectAt(0));
        SignerInfo signerInfo = SignerInfo.getInstance(this.signedAndEnvelopedData.getSignerInfos().getObjectAt(0));
        String issuer = recipientCert.getIssuer();
        IssuerAndSerialNumber userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn = recipientCert.getSerialNumber());
        if (!userIssuerAndSN.equals(actualIssuerAndSN = recipientInfo.getIssuerAndSerialNumber())) {
            throw new PKIException("850636", "\u4f7f\u7528\u7684\u79c1\u94a5\u8bc1\u4e66\u548c\u5c01\u88c5\u5e26\u7b7e\u540d\u7684\u6570\u5b57\u4fe1\u5c01\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
        }
        byte[] encryptedKey = recipientInfo.getEncryptedKey().getOctets();
        byte[] decryptedKey = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), recipientPriKey, encryptedKey);
        AlgorithmIdentifier alg = encryptedContentInfo.getContentEncryptionAlgorithm();
        DERObjectIdentifier encryptionAlgId = alg.getObjectId();
        byte[] encryptedData = encryptedContentInfo.getEncryptedContent().getOctets();
        JKey sessionKey = null;
        Mechanism mechanism = null;
        String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(encryptionAlgId);
        if (encryptionAlgStr.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)alg.getParameters();
            byte[] iv = null;
            CBCParam cbcParam = new CBCParam();
            iv = doct.getOctets();
            cbcParam.setIv(iv);
            if (encryptionAlgStr.equals("DES/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DES/CBC/PKCS7Padding", cbcParam);
                sessionKey = new JKey("DES", decryptedKey);
            } else if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                sessionKey = new JKey("DESede", decryptedKey);
            }
        } else if (encryptionAlgStr.indexOf("ECB") != -1) {
            if (encryptionAlgStr.equals("DES/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DES/ECB/PKCS7Padding");
                sessionKey = new JKey("DES", decryptedKey);
            } else if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                sessionKey = new JKey("DESede", decryptedKey);
            }
        } else {
            throw new PKIException("850629", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        byte[] decryptedContentData = this.session.decrypt(mechanism, sessionKey, encryptedData);
        byte[] encryptedSignedData = signerInfo.getEncryptedDigest().getOctets();
        byte[] decryptedSignedData = this.session.decrypt(mechanism, sessionKey, encryptedSignedData);
        issuer = signerCert.getIssuer();
        sn = signerCert.getSerialNumber();
        userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        actualIssuerAndSN = signerInfo.getIssuerAndSerialNumber();
        if (!userIssuerAndSN.equals(actualIssuerAndSN)) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        DERObjectIdentifier digestAlgId = signerInfo.getDigestAlgorithm().getObjectId();
        if (!digestAlgId.equals(PKCSObjectIdentifiers.sha1)) {
            throw new PKIException("850629", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        Mechanism signM = new Mechanism("SHA1withRSAEncryption");
        JKey pubKey = signerCert.getPublicKey();
        if (!this.session.verifySign(signM, pubKey, decryptedContentData, decryptedSignedData)) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        return decryptedContentData;
    }

    public byte[] getContentExtendC(X509Cert recipientCert, JKey recipientPriKey, X509Cert signerCert) throws PKIException {
        IssuerAndSerialNumber actualIssuerAndSN;
        BigInteger sn;
        if (this.signedAndEnvelopedData == null) {
            throw new PKIException("850630", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e3a\u7a7a");
        }
        if (signerCert == null) {
            throw new PKIException("850626", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        if (recipientCert == null) {
            throw new PKIException("850626", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u7684\u8bc1\u4e66\u4e3a\u7a7a");
        }
        EncryptedContentInfo encryptedContentInfo = this.signedAndEnvelopedData.getEncryptedContentInfo();
        RecipientInfo recipientInfo = RecipientInfo.getInstance(this.signedAndEnvelopedData.getRecipientInfos().getObjectAt(0));
        SignerInfo signerInfo = SignerInfo.getInstance(this.signedAndEnvelopedData.getSignerInfos().getObjectAt(0));
        String issuer = recipientCert.getIssuer();
        IssuerAndSerialNumber userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn = recipientCert.getSerialNumber());
        if (!userIssuerAndSN.equals(actualIssuerAndSN = recipientInfo.getIssuerAndSerialNumber())) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        byte[] encryptedKey = recipientInfo.getEncryptedKey().getOctets();
        byte[] decryptedKey = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), recipientPriKey, encryptedKey);
        AlgorithmIdentifier alg = encryptedContentInfo.getContentEncryptionAlgorithm();
        DERObjectIdentifier encryptionAlgId = alg.getObjectId();
        byte[] encryptedData = encryptedContentInfo.getEncryptedContent().getOctets();
        JKey sessionKey = null;
        Mechanism mechanism = null;
        String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(encryptionAlgId);
        if (encryptionAlgStr.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)alg.getParameters();
            byte[] iv = null;
            CBCParam cbcParam = new CBCParam();
            iv = doct.getOctets();
            cbcParam.setIv(iv);
            if (encryptionAlgStr.equals("DES/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DES/CBC/PKCS7Padding", cbcParam);
                sessionKey = new JKey("DES", decryptedKey);
            } else if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                sessionKey = new JKey("DESede", decryptedKey);
            }
        } else if (encryptionAlgStr.indexOf("ECB") != -1) {
            if (encryptionAlgStr.equals("DES/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DES/ECB/PKCS7Padding");
                sessionKey = new JKey("DES", decryptedKey);
            } else if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                sessionKey = new JKey("DESede", decryptedKey);
            }
        } else {
            throw new PKIException("850629", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        byte[] decryptedContentData = this.session.decrypt(mechanism, sessionKey, encryptedData);
        byte[] encryptedDigestContentData = this.session.encrypt(mechanism, sessionKey, decryptedContentData);
        issuer = signerCert.getIssuer();
        sn = signerCert.getSerialNumber();
        userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        actualIssuerAndSN = signerInfo.getIssuerAndSerialNumber();
        if (!userIssuerAndSN.equals(actualIssuerAndSN)) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        DERObjectIdentifier digestAlgId = signerInfo.getDigestAlgorithm().getObjectId();
        if (!digestAlgId.equals(PKCSObjectIdentifiers.sha1)) {
            throw new PKIException("850629", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        Mechanism signM = new Mechanism("SHA1withRSAEncryption");
        JKey pubKey = signerCert.getPublicKey();
        if (!this.session.verifySign(signM, pubKey, encryptedDigestContentData, signerInfo.getEncryptedDigest().getOctets())) {
            throw new PKIException("850627", "\u89e3\u6790\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25");
        }
        return decryptedContentData;
    }

    public byte[] getContentExtendC(Pfx recipientPfx, char[] pfxPwd, X509Cert signerCert) throws PKIException {
        PKCS12 p12Parser = new PKCS12();
        p12Parser.load(recipientPfx);
        p12Parser.decrypt(pfxPwd);
        JKey recipientPriKey = p12Parser.getPrivateKey();
        X509Cert recipientCert = p12Parser.getCertificate();
        return this.getContentExtendC(recipientCert, recipientPriKey, signerCert);
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism mechanism = new Mechanism("DES/ECB/PKCS7Padding");
            PKCS7SignEnvData P7SignEnvData = new PKCS7SignEnvData(session);
            FileInputStream is = new FileInputStream("C:/asp.cer");
            X509Cert cert = new X509Cert(is);
            PKCS12 p12 = new PKCS12();
            p12.load("C:/ccb.pfx");
            p12.decrypt("111".toCharArray());
            Pfx pfx = p12.getPfx();
            byte[] envelopedData = P7SignEnvData.generateSigAndEnvelop(PKCS7SignedData.DATA, "abcd".getBytes(), mechanism, cert, pfx, "111".toCharArray());
            envelopedData = P7SignEnvData.generateSignedAndEnvelopedDataContent(envelopedData);
            FileOutputStream fos = new FileOutputStream("C:/SigAndEnvelopedData");
            fos.write(envelopedData);
            fos.close();
            PKCS12 p12Receive = new PKCS12();
            p12Receive.load("C:/asp.pfx");
            p12Receive.decrypt("111".toCharArray());
            Pfx pfxReceive = p12Receive.getPfx();
            FileInputStream is22 = new FileInputStream("C:/ccb.cer");
            X509Cert certSigner = new X509Cert(is22);
            P7SignEnvData.load("C:/SigAndEnvelopedData");
            byte[] data = P7SignEnvData.getContent(pfxReceive, "111".toCharArray(), certSigner);
            FileOutputStream fos1 = new FileOutputStream("C:/SignAndEncSourceData");
            System.out.println("OK!");
            fos1.write(data);
            fos1.close();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

