/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.BERSet;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs12.Pfx;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignedData;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignerInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.CertificateList;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;

public class PKCS7SignedData {
    private Session session = null;
    private SignedData signedData = null;
    static final String pkcs_7 = "1.2.840.113549.1.7";
    public static final String DATA = new DERObjectIdentifier("1.2.840.113549.1.7.1").getId();
    public static final String SIGNED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.2").getId();
    public static final String ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.3").getId();
    public static final String SIGNED_ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.4").getId();
    public static final String DIGESTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.5").getId();
    public static final String ENCRYPTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.6").getId();

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public byte[] generateSignedData(boolean withContent, String contentType, InputStream sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        try {
            byte[] content = new byte[sourceData.available()];
            sourceData.read(content);
            sourceData.close();
            return this.generateSignedData(withContent, contentType, content, digestAlg, privateKey, cert, crl);
        }
        catch (Exception ex) {
            throw new PKIException("850614", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
    }

    public byte[] generateSignedData(boolean withContent, String contentType, byte[] sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, sourceData);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        DEROctetString derSourceData = new DEROctetString(sourceData);
        ContentInfo contentInfo = null;
        contentInfo = withContent ? (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new DERObjectIdentifier(contentType), derSourceData)) : (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data) : new ContentInfo(new DERObjectIdentifier(contentType)));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < cert.length; ++i) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        BERSet setCRL = null;
        if (crl != null) {
            for (int i = 0; i < crl.length; ++i) {
                CertificateList certList = crl[i].getCertificateList();
                v.add(certList);
            }
            setCRL = new BERSet(v);
        }
        SignedData signedData = new SignedData(new DERInteger(1), digestAlgorithms, contentInfo, setCert, setCRL, signerInfos);
        return Parser.writeDERObj2Bytes(signedData);
    }

    public byte[] reSignSignedData(Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (this.signedData == null) {
            throw new PKIException("850648", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u52a0\u8f7d\u5148\u524d\u7684\u7b7e\u540d\u6570\u636e");
        }
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContent() == null) {
            throw new PKIException("850647", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u5f85\u7b7e\u540d\u7684\u660e\u6587");
        }
        sourceData = contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) ? ((ASN1OctetString)contentInfo.getContent()).getOctets() : Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        ASN1Set signerCerts = this.signedData.getCertificates();
        ASN1Set signerCRLs = this.signedData.getCrls();
        ASN1Set digestAlgs = this.signedData.getDigestAlgorithms();
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, sourceData);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        ASN1EncodableVector signInfoDerVec = new ASN1EncodableVector();
        Enumeration enumer = signerInfos.getObjects();
        if (enumer.hasMoreElements()) {
            signInfoDerVec.add((DEREncodable)enumer.nextElement());
        }
        signInfoDerVec.add(signerInfo);
        DERSet newSignerInfos = new DERSet(signInfoDerVec);
        this.signedData.setSignerInfos(newSignerInfos);
        ASN1EncodableVector certsVec = new ASN1EncodableVector();
        enumer = signerCerts.getObjects();
        if (enumer.hasMoreElements()) {
            certsVec.add((DEREncodable)enumer.nextElement());
        }
        for (int i = 0; i < cert.length; ++i) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            certsVec.add(certStruc);
        }
        BERSet setCert = new BERSet(certsVec);
        this.signedData.setCertificates(setCert);
        BERSet setCRL = null;
        if (crl != null) {
            ASN1EncodableVector crlsVec = new ASN1EncodableVector();
            enumer = signerCRLs.getObjects();
            if (enumer.hasMoreElements()) {
                crlsVec.add((DEREncodable)enumer.nextElement());
            }
            for (int i = 0; i < crl.length; ++i) {
                CertificateList certList = crl[i].getCertificateList();
                crlsVec.add(certList);
            }
            setCRL = new BERSet(crlsVec);
        }
        this.signedData.setCrls(setCRL);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        enumer = digestAlgs.getObjects();
        if (enumer.hasMoreElements()) {
            derV.add((DEREncodable)enumer.nextElement());
        }
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        this.signedData.setDigestAlgorithms(digestAlgorithms);
        return Parser.writeDERObj2Bytes(this.signedData);
    }

    public byte[] generateSignedDataContent(byte[] content) throws PKIException {
        SignedData signedData = SignedData.getInstance(Parser.writeBytes2DERObj(content));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return Parser.writeDERObj2Bytes(contentInfo);
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        ByteArrayInputStream bis = null;
        if (isB64) {
            byte[] tmpData = Parser.convertBase64(data);
            tmpData = Base64.decode(tmpData);
            bis = new ByteArrayInputStream(tmpData);
        }
        bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void loadBase64(byte[] data) throws PKIException {
        byte[] tmpData = Parser.convertBase64(data);
        tmpData = Base64.decode(tmpData);
        ByteArrayInputStream bis = new ByteArrayInputStream(tmpData);
        this.load(bis);
    }

    public void loadDer(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(SignedData signedData) throws PKIException {
        this.signedData = signedData;
    }

    public void loadDer(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.loadDer(data);
    }

    public void loadBase64(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.loadBase64(data);
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.load(data);
    }

    private void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedData sd = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.signedData = sd;
    }

    public byte[] getContent() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContent() == null) {
            return null;
        }
        sourceData = contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) ? ((ASN1OctetString)contentInfo.getContent()).getOctets() : Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        return sourceData;
    }

    public X509Cert[] getSignerCerts() throws PKIException {
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            X509CertificateStructure certStru = X509CertificateStructure.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
        }
        return signerCerts;
    }

    private boolean verifySignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            while (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (!encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
                if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                    signM = new Mechanism("MD2withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                JKey pubKey = signerCert.getPublicKey();
                if (this.session.verifySign(signM, pubKey, content, signature)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySignerInfo(InputStream content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            while (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (!encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
                if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                    signM = new Mechanism("MD2withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                JKey pubKey = signerCert.getPublicKey();
                if (this.session.verifySign(signM, pubKey, content, signature)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    public boolean verifyP7SignedData(X509Cert[] certs) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData, X509Cert[] certs) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    public boolean verifyP7SignedData(InputStream sourceData, X509Cert[] certs) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData(InputStream sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            String tmpIssuer = certs[i].getIssuer();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            Mechanism mechanism1 = new Mechanism("SHA1");
            PKCS12 p12 = new PKCS12();
            p12.load("E:\\test\\cfca\\test.pfx");
            p12.decrypt("1234".toCharArray());
            Pfx pfx = p12.getPfx();
            byte[] signData = null;
            signData = p7.generateSignedData(false, DATA, "\u4e2d\u56fd\u91d1\u878d\u8ba4\u8bc1\u4e2d\u5fc3".getBytes(), mechanism1, p12.getPrivateKey(), p12.getCerts(), null);
            signData = p7.generateSignedDataContent(signData);
            byte[] b64 = Base64.encode(signData);
            signData = Parser.singleLine2MultiLine(b64);
            FileOutputStream fos = new FileOutputStream("e:/test/cfca/signedData.txt");
            fos.write(signData);
            fos.close();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

