/*
 * Decompiled with CFR 0.152.
 */
package jpack.security;

import cryptix.provider.Cryptix;
import cryptix.provider.key.RawKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Security;
import jpack.security.BasicCipher;
import xjava.security.Cipher;

public class Cipher3
extends BasicCipher {
    private Cipher cides;
    private static int keySpace = 16;
    private static byte[] sessionKey = new byte[]{97, 114, 97, 99, 104, 110, 111, 105};

    public Cipher3() throws Exception {
        Security.addProvider(new Cryptix());
        this.createCipher();
    }

    private void createCipher() throws Exception {
        this.cides = Cipher.getInstance("DES/CBC/PKCS#7", "Cryptix");
    }

    private byte[] hash(byte[] buf, byte[] ins, int ks) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(buf.length + ins.length);
        int bidx = 0;
        int iidx = 0;
        while (bidx < buf.length || iidx < ins.length) {
            int ofs = buf.length - bidx;
            if (ofs > 0) {
                int rs = ofs > ks ? ks : ofs;
                bo.write(buf, bidx, rs);
                bidx += rs;
            }
            if (iidx >= ins.length) continue;
            bo.write(ins, iidx++, 1);
        }
        return bo.toByteArray();
    }

    private byte[] crypt(byte[] inData, int mode) {
        try {
            if (inData == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (mode == 0) {
                byte[] keyBuf = BasicCipher.genSessionKey(8);
                this.cides.initEncrypt(new RawKey("DES", sessionKey));
                byte[] seckey = this.cides.crypt(keyBuf);
                this.createCipher();
                this.cides.initEncrypt(new RawKey("DES", keyBuf));
                byte[] outData = this.cides.crypt(inData);
                byte[] byArray = this.hash(outData, seckey, keySpace);
                return byArray;
            }
            ByteArrayInputStream bi = new ByteArrayInputStream(inData);
            int dtsz = inData.length - 16;
            ByteArrayOutputStream bo = new ByteArrayOutputStream(dtsz);
            ByteArrayOutputStream bk = new ByteArrayOutputStream(16);
            int keyRead = 0;
            while (bi.available() > 0) {
                if (dtsz > 0) {
                    byte[] dat = new byte[dtsz > keySpace ? keySpace : dtsz];
                    bi.read(dat);
                    bo.write(dat);
                    dtsz -= dat.length;
                }
                if (bi.available() <= 0 || keyRead++ >= 16) continue;
                bk.write(bi.read());
            }
            byte[] seck = bk.toByteArray();
            this.cides.initDecrypt(new RawKey("DES", sessionKey));
            byte[] k = this.cides.crypt(seck);
            this.createCipher();
            this.cides.initDecrypt(new RawKey("DES", k));
            byte[] byArray = this.cides.crypt(bo.toByteArray());
            return byArray;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public byte[] encrypt(byte[] inData) {
        return this.crypt(inData, 0);
    }

    public byte[] decrypt(byte[] inData) {
        return this.crypt(inData, 1);
    }
}

