/*
 * Decompiled with CFR 0.152.
 */
package jpack.security;

import cryptix.provider.Cryptix;
import cryptix.provider.rsa.RawRSAPrivateKey;
import cryptix.provider.rsa.RawRSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.Security;
import java.security.Signature;
import java.util.Enumeration;
import java.util.Hashtable;
import jpack.security.BasicCipher;
import jpack.util.Base64;
import jpack.util.StdLib;
import xjava.security.Cipher;

public final class SSLCipher
extends BasicCipher {
    private String KEYFILE = ".//keystore.dat";
    private String PRIVATE_KEY = "SK";
    private String PUBLIC_KEY = "PK";
    private Cipher cirsa;
    private Cipher ci3des;
    private Signature cisng;
    private KeyStore ks;

    public SSLCipher() throws Exception {
        Security.addProvider(new Cryptix());
        this.cirsa = Cipher.getInstance("RSA/ECB/PKCS#7", "Cryptix");
        this.ci3des = Cipher.getInstance("DES-EDE3/CBC/PKCS#7", "Cryptix");
        this.cisng = Signature.getInstance("MD5/RSA/PKCS#1", "Cryptix");
        this.ks = new KeyStore();
    }

    private static int readShort(InputStream ins) throws Exception {
        return (ins.read() << 8) + 7 + ins.read();
    }

    private static BigInteger readBInt(InputStream ins) throws Exception {
        int i = SSLCipher.readShort(ins) >> 3;
        byte[] b = new byte[2 + i];
        ins.read(b, 2, i);
        return new BigInteger(b);
    }

    private void importKey() {
    }

    private byte[] crypt(byte[] inData, int mode) {
        try {
            if (inData == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (mode == 0) {
                ByteArrayOutputStream ret = new ByteArrayOutputStream(512);
                byte[] senKey = BasicCipher.genSessionKey(24);
                this.cirsa.initEncrypt(this.ks.getKey(0));
                byte[] cryptSen = this.cirsa.crypt(senKey);
                this.cisng.initSign((RawRSAPrivateKey)this.ks.getKey(2));
                this.cisng.update(inData);
                byte[] psgn = this.cisng.sign();
                this.ci3des.initEncrypt(new K(this, senKey));
                byte[] cryptData = this.ci3des.crypt(inData);
                ret.write(StdLib.shortToBytes(psgn.length));
                ret.write(psgn);
                ret.write(StdLib.shortToBytes(cryptSen.length));
                ret.write(cryptSen);
                ret.write(StdLib.intToBytes(cryptData.length));
                ret.write(cryptData);
                ret.flush();
                byte[] byArray = ret.toByteArray();
                return byArray;
            }
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(inData));
            byte[] psgn = new byte[is.readShort()];
            is.read(psgn);
            byte[] cryptSen = new byte[is.readShort()];
            is.read(cryptSen);
            this.cirsa.initDecrypt((RawRSAPrivateKey)this.ks.getKey(2));
            byte[] senKey = this.cirsa.crypt(cryptSen);
            this.ci3des.initDecrypt(new K(this, senKey));
            byte[] cryptData = new byte[is.readInt()];
            is.read(cryptData);
            byte[] outData = this.ci3des.crypt(cryptData);
            this.cisng.initVerify((RawRSAPublicKey)this.ks.getKey(0));
            this.cisng.update(outData);
            if (this.cisng.verify(psgn)) {
                byte[] byArray = outData;
                return byArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte[] encrypt(byte[] inData) {
        return this.crypt(inData, 0);
    }

    public byte[] decrypt(byte[] inData) {
        return this.crypt(inData, 1);
    }

    private class K
    implements Key {
        private final byte[] keyBytes;
        private final String alg;

        K(SSLCipher this$0, byte[] keyBytes) {
            this.alg = "3DES";
            this.keyBytes = keyBytes;
        }

        public String getAlgorithm() {
            return this.alg;
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.keyBytes.clone();
        }
    }

    private final class KeyStore
    extends Hashtable {
        private int seed = 0;
        private static final String KEYDATA = "0C44C4BF86994BDBA0DF9D2F8EC12849AFDk8XX3iowRgtZ1BADFahdxNfyYdywOlKCgLyrhRXZXH6aK3UnQrWGVy06tO+U+Yreouuy46msTxrhwi3IDpa6h83i5jX9i17PBW6hkIJNXZtFdMGXc5OVZev4sud9O9tUqdnWzV3kF8XN9bY+q0PRhgN4yFUKIXDGD2SHA9NeC6vqXxazCnlHG6R4nRw==AFD48MEDjO9AW6rRBADM5FDtTICC3S1FSQdprtuORQA+7VEZ0Qj/SvuwzlWVO0qmJRdkVUkRqnw+9QbIPWsSDWWFJaqK8Xqy2/9EsOe41RCSTjfToI0vvrwV/ia0q6TJCPFTbfVP40dOdUNAbMS116e1aYCKS6zDIzK3EtEuJL5GH6BzLAUzu1hvMIa/EQ==A/9vfKVdRv5IH5wysL2qCG7SXTRHADIlW0SCSNXqGlhD4D6zuChDV9fFmIhAnHQnu3QfE9r2mfJAg9OGA4TSzFRsm0laP8PL5UdoGjTA335SdniorHn0kGEFd/+ZOrMvcrGKOqHGSULgSab53ORyN/cPprk5HCViWxp2Pz8XNIq/BQIA30T9Mst0gWbm3CgMEoDBaoGPa+aHLLBvYiPsO0OTJb+vMevfXHfWqSsTAiwlAGtlQZ+p6U9KlsxTd4hTRExc0wIA6u2jhsRF58anxHsoIJ6VFgMnd780DJ93QHcuibUm4qpFxgtPC5tgHLQtgf6VazFiwQn6JGTAnUH0VVCm6ET2CwIAtQIiV2Z6UWd21ki5Lfds8KhDFsGi5t7CuM1BnJtBxXiOdwyBODUr+xxTfBFC9GJ9+wns+IrXJ8g5iWfqfD2vLA==";

        KeyStore() {
            try {
                FileInputStream fo = new FileInputStream(SSLCipher.this.KEYFILE);
                this.readObject(fo);
                fo.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        Key getKey(int mode) throws Exception {
            if (mode <= 1) {
                ByteArrayInputStream fi = mode == 0 ? new ByteArrayInputStream(Base64.decode(KEYDATA.substring(32, 224))) : new ByteArrayInputStream(Base64.decode(KEYDATA.substring(224, 416)));
                return new RRawRSAPublicKey(SSLCipher.this, SSLCipher.readBInt(fi), SSLCipher.readBInt(fi));
            }
            ByteArrayInputStream fi = new ByteArrayInputStream(Base64.decode(KEYDATA.substring(416)));
            return new RawRSAPrivateKey(SSLCipher.readBInt(fi), SSLCipher.readBInt(fi), SSLCipher.readBInt(fi), SSLCipher.readBInt(fi));
        }

        private int writeByte(OutputStream os, byte[] data, int seed, int mod) throws Exception {
            if (mod == 0) {
                seed = this.writeByte(os, StdLib.intToBytes(data.length), seed, 1);
                return this.writeByte(os, data, seed, 1);
            }
            for (int i = 0; i < data.length; ++i) {
                os.write(seed ^= data[i]);
            }
            return seed;
        }

        private byte[] readByte(InputStream is, int len) throws Exception {
            byte[] ret = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.seed = is.read() ^ this.seed;
                ret[i] = (byte)this.seed;
            }
            return ret;
        }

        public boolean store() {
            try {
                FileOutputStream fo = new FileOutputStream(SSLCipher.this.KEYFILE);
                this.writeObject(fo);
                fo.close();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
        }

        private synchronized void writeObject(OutputStream s) throws Exception {
            int seed = 0;
            this.writeByte(s, StdLib.intToBytes(this.size()), seed, 1);
            Enumeration ks = this.keys();
            while (ks.hasMoreElements()) {
                String k = (String)ks.nextElement();
                this.writeByte(s, (byte[])this.get(k), this.writeByte(s, k.getBytes(), seed, 0), 0);
            }
        }

        private synchronized void readObject(InputStream s) throws Exception {
            this.clear();
            this.seed = 0;
            int cnt = StdLib.byteToInt(this.readByte(s, 4), 0);
            for (int i = 0; i < cnt; ++i) {
                this.put(new String(this.readByte(s, StdLib.byteToInt(this.readByte(s, 4), 0))), this.readByte(s, StdLib.byteToInt(this.readByte(s, 4), 0)));
            }
        }

        static {
            KEYDATA = KEYDATA;
        }
    }

    private final class RRawRSAPublicKey
    extends RawRSAPublicKey {
        RRawRSAPublicKey(SSLCipher this$0, BigInteger e, BigInteger n) {
            super(n, e);
        }
    }
}

