/*
 * Decompiled with CFR 0.152.
 */
package xdesign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jpack.util.StdLib;
import xdesign.XCUnPack_3_1_1;
import xdesign.XCUnPack_3_1_2;
import xdesign.XCUnPack_3_1_3;
import xdesign.XCUnPack_3_2_1;
import xdesign.XCUnPack_3_6_1;
import xdesign.XCUnPack_3_A_X;
import xdesign.XCUnPack_3_X_X;
import xdesign.XException;

class XCLib {
    static int COUNT_SIZE = 4;

    XCLib() {
    }

    static byte[] getCheckPacket(String productID, String timeStamp, int sequenceNo, byte[] padding) throws XException {
        if (!StdLib.isNumber(timeStamp) || timeStamp.length() != 14) {
            throw new XException(9);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(timeStamp.getBytes());
            os.write(StdLib.intToBytes(sequenceNo));
            os.write(StdLib.intToBytes(productID.length(), 1));
            os.write(productID.getBytes());
            if (padding == null) {
                os.write(StdLib.intToBytes(0, 1));
            } else {
                os.write(StdLib.intToBytes(padding.length, 1));
                os.write(padding);
            }
        }
        catch (IOException e) {
            throw new XException(5);
        }
        return os.toByteArray();
    }

    static XCUnPack_3_X_X doCUnPack(byte[] packet) throws XException {
        XCUnPack_3_X_X unPack;
        int version = StdLib.unsignByte(packet[0]);
        int svcType = StdLib.unsignByte(packet[1]);
        int svcCode = StdLib.unsignByte(packet[2]);
        block0 : switch (version) {
            case 3: {
                switch (svcType) {
                    case 1: {
                        switch (svcCode) {
                            case 1: {
                                unPack = new XCUnPack_3_1_1(packet, 7);
                                break block0;
                            }
                            case 2: {
                                unPack = new XCUnPack_3_1_2(packet, 7);
                                break block0;
                            }
                            case 3: {
                                unPack = new XCUnPack_3_1_3(packet, 7);
                                break block0;
                            }
                        }
                        throw new XException(2);
                    }
                    case 2: {
                        switch (svcCode) {
                            case 1: {
                                unPack = new XCUnPack_3_2_1(packet, 7);
                                break block0;
                            }
                        }
                        throw new XException(2);
                    }
                    case 3: 
                    case 4: {
                        unPack = new XCUnPack_3_A_X(packet, 7);
                        break block0;
                    }
                    case 6: {
                        switch (svcCode) {
                            case 1: {
                                unPack = new XCUnPack_3_6_1(packet, 7);
                                break block0;
                            }
                        }
                        throw new XException(2);
                    }
                }
                throw new XException(2);
            }
            default: {
                throw new XException(2);
            }
        }
        unPack.version = version;
        unPack.svcType = svcType;
        unPack.svcCode = svcCode;
        return unPack;
    }

    static void checkMustString(String str) throws XException {
        if (str == null || str.length() == 0) {
            throw new XException(215);
        }
    }

    static void checkStringSize(String str) throws XException {
        if (str != null && str.length() > 255) {
            throw new XException(46);
        }
    }

    public static void checkMustBytes(byte[] buf) throws XException {
        if (buf == null || buf.length == 0) {
            throw new XException(215);
        }
    }
}

