/*
 * Decompiled with CFR 0.152.
 */
package xdesign;

import java.io.IOException;
import jpack.io.AdvByteArrayInputStream;
import jpack.security.Cipher;
import jpack.util.StdLib;
import xdesign.XException;

abstract class XCUnPack_3_X_X {
    public static int TIMESTAMP_LEN = 14;
    public static int VERSION = 3;
    public int version;
    public int svcType;
    public int svcCode;
    public int packetType;
    public String timeStamp;
    public int sequenceNo;
    public byte[] padding;
    public int resultCode = 229;
    public int purpose;

    abstract void unPack(AdvByteArrayInputStream var1) throws IOException;

    protected void init() {
        this.version = VERSION;
    }

    public XCUnPack_3_X_X() {
        this.init();
    }

    public XCUnPack_3_X_X(byte[] buf, int offset) throws XException {
        this.init();
        this.setPacket(buf, offset);
    }

    public void clear() {
        this.packetType = 0;
        this.timeStamp = "";
        this.sequenceNo = 0;
        this.padding = null;
        this.resultCode = 229;
        this.purpose = 0;
    }

    public void setPacket(byte[] packet, int offset) throws XException {
        if (packet == null) {
            throw new XException(215);
        }
        int realType = StdLib.unsignByte(packet[offset]);
        this.packetType = realType - 4;
        byte[] buf = new byte[packet.length - offset - 1];
        System.arraycopy(packet, offset + 1, buf, 0, packet.length - offset - 1);
        try {
            Cipher ci = new Cipher(realType);
            buf = ci.decrypt(buf);
        }
        catch (Exception e) {
            throw new XException(7);
        }
        if (buf == null) {
            throw new XException(7);
        }
        AdvByteArrayInputStream is = new AdvByteArrayInputStream(buf);
        try {
            this.timeStamp = is.readString(TIMESTAMP_LEN);
            this.sequenceNo = is.readInt();
            int iLen = is.readUnsignByte();
            this.padding = is.readBytes(iLen);
            this.purpose = is.readUnsignByte();
            this.resultCode = is.readInt();
            this.unPack(is);
        }
        catch (IOException e) {
            throw new XException(5);
        }
    }

    public void setPacket(byte[] packet) throws XException {
        this.setPacket(packet, 0);
    }
}

