/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.AnimationState;
import org.jdesktop.animation.transitions.ComponentState;

class AnimationManager {
    private Map<JComponent, AnimationState> componentAnimationStates = new HashMap<JComponent, AnimationState>();
    private ArrayList<JComponent> changingComponents = new ArrayList();
    JComponent container = null;
    private BufferedImage transitionImageBG = null;

    AnimationManager(JComponent container) {
        this.container = container;
        this.recreateImage();
    }

    void recreateImage() {
        int cw = this.container.getWidth();
        int ch = this.container.getHeight();
        if (cw > 0 && ch > 0 && (this.transitionImageBG == null || cw != this.transitionImageBG.getWidth() || ch != this.transitionImageBG.getHeight())) {
            this.transitionImageBG = (BufferedImage)this.container.createImage(cw, ch);
        }
    }

    private AnimationState getExistingAnimationState(Component component) {
        return this.componentAnimationStates.get(component);
    }

    void reset(Animator animator) {
        Iterator<AnimationState> i$ = this.componentAnimationStates.values().iterator();
        while (i$.hasNext()) {
            AnimationState state = i$.next();
            state.cleanup(animator);
        }
        this.componentAnimationStates.clear();
        this.changingComponents.clear();
    }

    void init(Animator animator) {
        this.recreateImage();
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        Iterator<Object> i$ = this.componentAnimationStates.values().iterator();
        while (i$.hasNext()) {
            Rectangle componentBounds;
            AnimationState state = i$.next();
            ComponentState start = state.getStart();
            ComponentState end = state.getEnd();
            Rectangle bounds = null;
            if (start != null) {
                bounds = new Rectangle(start.getX(), start.getY(), start.getWidth(), start.getHeight());
            }
            if (end != null) {
                Rectangle boundsEnd = new Rectangle(end.getX(), end.getY(), end.getWidth(), end.getHeight());
                bounds = bounds == null ? boundsEnd : bounds.union(boundsEnd);
            }
            if (bounds.intersects(componentBounds = this.container.getBounds())) continue;
            componentsToRemove.add(state.getComponent());
        }
        i$ = componentsToRemove.iterator();
        while (i$.hasNext()) {
            Component component = (Component)((Object)i$.next());
            this.componentAnimationStates.remove(component);
            this.changingComponents.remove(component);
        }
        i$ = this.changingComponents.iterator();
        while (i$.hasNext()) {
            JComponent child = (JComponent)i$.next();
            child.setVisible(false);
        }
        Graphics gImg = this.transitionImageBG.getGraphics();
        gImg.clearRect(0, 0, this.transitionImageBG.getWidth(), this.transitionImageBG.getHeight());
        ComponentState.paintHierarchySingleBuffered(this.container, gImg);
        gImg.dispose();
        Iterator<Object> i$2 = this.changingComponents.iterator();
        while (i$2.hasNext()) {
            JComponent child = i$2.next();
            child.setVisible(true);
        }
        i$2 = this.componentAnimationStates.values().iterator();
        while (i$2.hasNext()) {
            AnimationState state = (AnimationState)i$2.next();
            state.init(animator);
        }
    }

    void setupStart() {
        Component[] arr$ = this.container.getComponents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Component child = arr$[i$];
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            this.addStart((JComponent)child);
        }
    }

    void setupEnd() {
        Component[] arr$ = this.container.getComponents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Component child = arr$[i$];
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            ComponentState end = new ComponentState((JComponent)child);
            AnimationState animState = this.getExistingAnimationState(child);
            if (animState != null) {
                ComponentState start = animState.getStart();
                if (start != null && start.equals(end)) {
                    this.componentAnimationStates.remove(child);
                    continue;
                }
                this.changingComponents.add((JComponent)child);
                animState.setEnd(end);
                continue;
            }
            this.changingComponents.add((JComponent)child);
            animState = new AnimationState(end, false);
            this.componentAnimationStates.put((JComponent)child, animState);
        }
    }

    void addStart(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setStart(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, true);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void addEnd(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setEnd(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, false);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void paint(Graphics g) {
        g.drawImage(this.transitionImageBG, 0, 0, null);
        Iterator<AnimationState> i$ = this.componentAnimationStates.values().iterator();
        while (i$.hasNext()) {
            AnimationState state = i$.next();
            state.paint(g);
        }
    }
}

