/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.config.exception.ConvertException;
import com.kingdee.util.OfdErrorType;
import com.kingdee.util.ofd.OfdConvertUtil;
import com.levigo.jbig2.JBIG2ImageReader;
import com.levigo.jbig2.JBIG2ImageReaderSpi;
import com.levigo.jbig2.io.DefaultInputStreamFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;

public class ExportQrCode {
    private static final Logger LOGGER = Logger.getLogger(ExportQrCode.class);
    private static final String SUFFIX_JB2 = "jb2";

    public static String getImageBase64(byte[] imageByte, String fileSuffix) {
        block41: {
            if (SUFFIX_JB2.equals(fileSuffix)) {
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(imageByte);
                     ImageInputStream imageInputStream = new DefaultInputStreamFactory().getInputStream((InputStream)inputStream);
                     ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
                    imageByte = out.toByteArray();
                    break block41;
                }
                catch (Exception e) {
                    throw new ConvertException(OfdErrorType.CREATE_QR_CODE_ERROR);
                }
            }
            try {
                imageByte = OfdConvertUtil.imageToPng(imageByte);
            }
            catch (IOException e) {
                throw new ConvertException(OfdErrorType.CREATE_QR_CODE_ERROR);
            }
        }
        return Base64.getEncoder().encodeToString(imageByte);
    }
}

