/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.util.StrUtil;
import com.kingdee.util.ofd.OfdConvertUtil;
import com.kingdee.util.ofd.OfdReadUtil;
import com.kingdee.util.ofd.OfdSignUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdUtil.class);

    public static Map<String, Object> getInvoiceMap(byte[] fileBytes) {
        return OfdReadUtil.extractData(fileBytes);
    }

    public static String getXbrlStr(byte[] fileBytes) {
        String str = null;
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            str = String.valueOf(invoiceMap.get("file_data"));
        }
        return str;
    }

    public static JSONObject getXbrlJson(byte[] fileBytes) {
        JSONObject jsonObject = null;
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            jsonObject = new JSONObject();
            jsonObject.put("name", (Object)StrUtil.nullToDefault((String)invoiceMap.get("file_name"), ""));
            jsonObject.put("message", (Object)String.valueOf(invoiceMap.get("file_data")));
        }
        return jsonObject;
    }

    public static JSONObject getInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getInvoiceMap(fileBytes)));
    }

    public static boolean verifySign(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, false);
    }

    public static boolean verifySignTax(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, true);
    }

    private static Map<String, Object> verifySignAndGetCerInfo(byte[] fileBytes) {
        return OfdSignUtil.verifySignAndGetCerInfo(fileBytes, true, false);
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.convertToSvg(fileBytes);
    }

    public static byte[] convertToPng(byte[] fileBytes) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, 1);
    }

    public static byte[] convertToImage(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, imageType);
    }

    public static List<Object> convertToMulPngStr(byte[] fileBytes) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, 1, -1);
    }

    public static List<Object> convertToHDMulImageStr(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, -1);
    }

    public static List<Object> convertToMulImageStr(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, imageType, -1);
    }

    public static String convertToImageByPageNo(byte[] fileBytes, float zoomScale, int imageType, int pageNo) {
        List<Object> list = OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, pageNo);
        String rsStr = null;
        if (list != null && !list.isEmpty()) {
            rsStr = (String)list.get(0);
        }
        return rsStr;
    }

    public static List<Object> convertToHDMulPngStr(byte[] fileBytes, float zoomScale) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, 1, -1);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes, -1);
    }

    public static List<byte[]> convertToPdfList(byte[] fileBytes, int pageNo) {
        return OfdConvertUtil.convertToPdfList(fileBytes, pageNo);
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes, -1);
    }

    public static byte[] convertToHDPng(byte[] fileBytes, float multipleNum) {
        return OfdConvertUtil.convertToImage(fileBytes, multipleNum, 1);
    }

    public static byte[] convertToHDImage(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, zoomScale, imageType);
    }
}

