/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1;

import com.apusic.org.bouncycastle.asn1.ASN1Encodable;
import com.apusic.org.bouncycastle.asn1.ASN1OctetString;
import com.apusic.org.bouncycastle.asn1.ASN1OutputStream;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DEROctetString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class BEROctetString
extends ASN1OctetString {
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private final int chunkSize;
    private final ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != octs.length; ++i) {
            try {
                bOut.write(octs[i].getOctets());
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("exception converting octets " + e.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BEROctetString(byte[] string) {
        this(string, 1000);
    }

    public BEROctetString(ASN1OctetString[] octs) {
        this(octs, 1000);
    }

    public BEROctetString(byte[] string, int chunkSize) {
        this(string, null, chunkSize);
    }

    public BEROctetString(ASN1OctetString[] octs, int chunkSize) {
        this(BEROctetString.toBytes(octs), octs, chunkSize);
    }

    private BEROctetString(byte[] string, ASN1OctetString[] octs, int chunkSize) {
        super(string);
        this.octs = octs;
        this.chunkSize = chunkSize;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return new Enumeration(){
                int pos = 0;

                public boolean hasMoreElements() {
                    return this.pos < BEROctetString.this.string.length;
                }

                public Object nextElement() {
                    if (this.pos < BEROctetString.this.string.length) {
                        int length = Math.min(BEROctetString.this.string.length - this.pos, BEROctetString.this.chunkSize);
                        byte[] chunk = new byte[length];
                        System.arraycopy(BEROctetString.this.string, this.pos, chunk, 0, length);
                        this.pos += length;
                        return new DEROctetString(chunk);
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        return new Enumeration(){
            int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.octs.length;
            }

            public Object nextElement() {
                if (this.counter < BEROctetString.this.octs.length) {
                    return BEROctetString.this.octs[this.counter++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    boolean isConstructed() {
        return true;
    }

    int encodedLength() throws IOException {
        int length = 0;
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            length += ((ASN1Encodable)e.nextElement()).toASN1Primitive().encodedLength();
        }
        return 2 + length + 2;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodedIndef(withTag, 36, this.getObjects());
    }

    static BEROctetString fromSequence(ASN1Sequence seq) {
        int count = seq.size();
        ASN1OctetString[] v = new ASN1OctetString[count];
        for (int i = 0; i < count; ++i) {
            v[i] = ASN1OctetString.getInstance(seq.getObjectAt(i));
        }
        return new BEROctetString(v);
    }
}

