/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1;

import com.apusic.org.bouncycastle.asn1.ASN1OctetString;
import com.apusic.org.bouncycastle.asn1.ASN1OutputStream;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1String;
import com.apusic.org.bouncycastle.asn1.ASN1TaggedObject;
import com.apusic.org.bouncycastle.asn1.StreamUtil;
import com.apusic.org.bouncycastle.util.Arrays;
import com.apusic.org.bouncycastle.util.Strings;
import java.io.IOException;

public class DERIA5String
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERIA5String getInstance(Object obj) {
        if (obj == null || obj instanceof DERIA5String) {
            return (DERIA5String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERIA5String)DERIA5String.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERIA5String) {
            return DERIA5String.getInstance(o);
        }
        return new DERIA5String(ASN1OctetString.getInstance(o).getOctets());
    }

    DERIA5String(byte[] string) {
        this.string = string;
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean validate) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        if (validate && !DERIA5String.isIA5String(string)) {
            throw new IllegalArgumentException("'string' contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncoded(withTag, 22, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERIA5String)) {
            return false;
        }
        DERIA5String s = (DERIA5String)o;
        return Arrays.areEqual(this.string, s.string);
    }

    public static boolean isIA5String(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

