/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1;

import com.apusic.org.bouncycastle.asn1.ASN1Encodable;
import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1OutputStream;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DEROutputStream;
import com.apusic.org.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DERSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public static DERSequence convert(ASN1Sequence seq) {
        return (DERSequence)seq.toDERObject();
    }

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable element) {
        super(element);
    }

    public DERSequence(ASN1EncodableVector elementVector) {
        super(elementVector);
    }

    public DERSequence(ASN1Encodable[] elements) {
        super(elements);
    }

    DERSequence(ASN1Encodable[] elements, boolean clone) {
        super(elements, clone);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength();
            }
            this.bodyLength = totalLength;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (withTag) {
            out.write(48);
        }
        DEROutputStream derOut = out.getDERSubStream();
        int count = this.elements.length;
        if (this.bodyLength >= 0 || count > 16) {
            out.writeLength(this.getBodyLength());
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                derObject.encode(derOut, true);
            }
        } else {
            int i;
            int totalLength = 0;
            ASN1Primitive[] derObjects = new ASN1Primitive[count];
            for (i = 0; i < count; ++i) {
                ASN1Primitive derObject;
                derObjects[i] = derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength();
            }
            this.bodyLength = totalLength;
            out.writeLength(totalLength);
            for (i = 0; i < count; ++i) {
                derObjects[i].encode(derOut, true);
            }
        }
    }

    ASN1Primitive toDERObject() {
        return this;
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

