/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.cmc;

import com.apusic.org.bouncycastle.asn1.ASN1Choice;
import com.apusic.org.bouncycastle.asn1.ASN1Encodable;
import com.apusic.org.bouncycastle.asn1.ASN1Integer;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.cmc.BodyPartID;
import com.apusic.org.bouncycastle.asn1.cmc.BodyPartPath;
import java.io.IOException;

public class BodyPartReference
extends ASN1Object
implements ASN1Choice {
    private final BodyPartID bodyPartID;
    private final BodyPartPath bodyPartPath;

    public BodyPartReference(BodyPartID bodyPartID) {
        this.bodyPartID = bodyPartID;
        this.bodyPartPath = null;
    }

    public BodyPartReference(BodyPartPath bodyPartPath) {
        this.bodyPartID = null;
        this.bodyPartPath = bodyPartPath;
    }

    public static BodyPartReference getInstance(Object obj) {
        if (obj instanceof BodyPartReference) {
            return (BodyPartReference)obj;
        }
        if (obj != null) {
            if (obj instanceof ASN1Encodable) {
                ASN1Primitive asn1Prim = ((ASN1Encodable)obj).toASN1Primitive();
                if (asn1Prim instanceof ASN1Integer) {
                    return new BodyPartReference(BodyPartID.getInstance(asn1Prim));
                }
                if (asn1Prim instanceof ASN1Sequence) {
                    return new BodyPartReference(BodyPartPath.getInstance(asn1Prim));
                }
            }
            if (obj instanceof byte[]) {
                try {
                    return BodyPartReference.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("unknown encoding in getInstance()");
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + obj.getClass().getName());
        }
        return null;
    }

    public boolean isBodyPartID() {
        return this.bodyPartID != null;
    }

    public BodyPartID getBodyPartID() {
        return this.bodyPartID;
    }

    public BodyPartPath getBodyPartPath() {
        return this.bodyPartPath;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.bodyPartID != null) {
            return this.bodyPartID.toASN1Primitive();
        }
        return this.bodyPartPath.toASN1Primitive();
    }
}

