/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.cmc;

import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DERSequence;
import com.apusic.org.bouncycastle.asn1.cmc.BodyPartReference;

public class ControlsProcessed
extends ASN1Object {
    private final ASN1Sequence bodyPartReferences;

    public ControlsProcessed(BodyPartReference bodyPartRef) {
        this.bodyPartReferences = new DERSequence(bodyPartRef);
    }

    public ControlsProcessed(BodyPartReference[] bodyList) {
        this.bodyPartReferences = new DERSequence(bodyList);
    }

    public static ControlsProcessed getInstance(Object src) {
        if (src instanceof ControlsProcessed) {
            return (ControlsProcessed)src;
        }
        if (src != null) {
            return new ControlsProcessed(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    private ControlsProcessed(ASN1Sequence seq) {
        if (seq.size() != 1) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.bodyPartReferences = ASN1Sequence.getInstance(seq.getObjectAt(0));
    }

    public BodyPartReference[] getBodyList() {
        BodyPartReference[] tmp = new BodyPartReference[this.bodyPartReferences.size()];
        for (int i = 0; i != this.bodyPartReferences.size(); ++i) {
            tmp[i] = BodyPartReference.getInstance(this.bodyPartReferences.getObjectAt(i));
        }
        return tmp;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.bodyPartReferences);
    }
}

