/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.its;

import com.apusic.org.bouncycastle.asn1.ASN1Integer;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.its.EndEntityType;
import com.apusic.org.bouncycastle.asn1.its.SubjectPermissions;
import java.math.BigInteger;

public class PsidGroupPermissions
extends ASN1Object {
    private final SubjectPermissions subjectPermissions;
    private final BigInteger minChainLength;
    private final BigInteger chainLengthRange;
    private final Object eeType;

    private PsidGroupPermissions(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("sequence not length 2");
        }
        this.subjectPermissions = SubjectPermissions.getInstance(seq.getObjectAt(0));
        this.minChainLength = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue();
        this.chainLengthRange = ASN1Integer.getInstance(seq.getObjectAt(2)).getValue();
        this.eeType = EndEntityType.getInstance(seq.getObjectAt(3));
    }

    public static PsidGroupPermissions getInstance(Object src) {
        if (src instanceof PsidGroupPermissions) {
            return (PsidGroupPermissions)src;
        }
        if (src != null) {
            return new PsidGroupPermissions(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return null;
    }
}

