/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.agreement;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.RawAgreement;
import com.apusic.org.bouncycastle.crypto.params.XDHUPrivateParameters;
import com.apusic.org.bouncycastle.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement xAgreement;
    private XDHUPrivateParameters privParams;

    public XDHUnifiedAgreement(RawAgreement xAgreement) {
        this.xAgreement = xAgreement;
    }

    public void init(CipherParameters key) {
        this.privParams = (XDHUPrivateParameters)key;
    }

    public int getAgreementSize() {
        return this.xAgreement.getAgreementSize() * 2;
    }

    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        XDHUPublicParameters pubParams = (XDHUPublicParameters)publicKey;
        this.xAgreement.init(this.privParams.getEphemeralPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getEphemeralPublicKey(), buf, off);
        this.xAgreement.init(this.privParams.getStaticPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getStaticPublicKey(), buf, off + this.xAgreement.getAgreementSize());
    }
}

