/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.generators;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.apusic.org.bouncycastle.crypto.KeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.apusic.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.params.DHParameters;
import com.apusic.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

