/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.generators;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.apusic.org.bouncycastle.crypto.KeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.params.DSAParameters;
import com.apusic.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.apusic.org.bouncycastle.math.ec.WNafUtil;
import com.apusic.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        BigInteger x;
        int minWeight = q.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random)) < minWeight) {
        }
        return x;
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

