/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.generators;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.apusic.org.bouncycastle.crypto.KeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.params.ECDomainParameters;
import com.apusic.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.apusic.org.bouncycastle.math.ec.ECConstants;
import com.apusic.org.bouncycastle.math.ec.ECMultiplier;
import com.apusic.org.bouncycastle.math.ec.ECPoint;
import com.apusic.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.apusic.org.bouncycastle.math.ec.WNafUtil;
import com.apusic.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = BigIntegers.createRandomBigInteger(nBitLength, this.random)).compareTo(ONE) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

