/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.modes.gcm;

import com.apusic.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.apusic.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.apusic.org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] H) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (0 != GCMUtil.areEqual(this.H, H)) {
            return;
        }
        this.H = new byte[16];
        GCMUtil.copy(H, this.H);
        for (int i = 0; i < 16; ++i) {
            long[][] t = this.T[i];
            if (i == 0) {
                GCMUtil.asLongs(this.H, t[1]);
                GCMUtil.multiplyP7(t[1], t[1]);
            } else {
                GCMUtil.multiplyP8(this.T[i - 1][1], t[1]);
            }
            for (int n = 2; n < 256; n += 2) {
                GCMUtil.divideP(t[n >> 1], t[n]);
                GCMUtil.xor(t[n], t[1], t[n + 1]);
            }
        }
    }

    public void multiplyH(byte[] x) {
        long[] t = this.T[15][x[15] & 0xFF];
        long z0 = t[0];
        long z1 = t[1];
        for (int i = 14; i >= 0; --i) {
            t = this.T[i][x[i] & 0xFF];
            z0 ^= t[0];
            z1 ^= t[1];
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }
}

