/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.digest;

import com.apusic.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.apusic.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.apusic.org.bouncycastle.crypto.CipherKeyGenerator;
import com.apusic.org.bouncycastle.crypto.digests.SHA224Digest;
import com.apusic.org.bouncycastle.crypto.macs.HMac;
import com.apusic.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.apusic.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.apusic.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA224 {
    private SHA224() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA224.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-224", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA224", "SHA-224");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
            provider.addAlgorithm("Mac.PBEWITHHMACSHA224", PREFIX + "$HashMac");
            this.addHMACAlgorithm(provider, "SHA224", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA224", 224, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA224Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA224Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SHA224Digest((SHA224Digest)this.digest);
            return d;
        }
    }
}

