/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.digest;

import com.apusic.org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import com.apusic.org.bouncycastle.crypto.CipherKeyGenerator;
import com.apusic.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import com.apusic.org.bouncycastle.crypto.macs.HMac;
import com.apusic.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.apusic.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.apusic.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            provider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

