/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.symmetric;

import com.apusic.org.bouncycastle.crypto.CipherKeyGenerator;
import com.apusic.org.bouncycastle.crypto.engines.VMPCEngine;
import com.apusic.org.bouncycastle.crypto.macs.VMPCMac;
import com.apusic.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.apusic.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class VMPC {
    private VMPC() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = VMPC.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.VMPC", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.VMPC", PREFIX + "$KeyGen");
            provider.addAlgorithm("Mac.VMPCMAC", PREFIX + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC", "VMPCMAC");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new VMPCMac());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("VMPC", 128, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new VMPCEngine(), 16);
        }
    }
}

