/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jsse;

import com.apusic.org.bouncycastle.tls.NameType;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.util.Arrays;
import com.apusic.org.bouncycastle.util.encoders.Hex;

public abstract class BCSNIServerName {
    private final int nameType;
    private final byte[] encoded;

    protected BCSNIServerName(int nameType, byte[] encoded) {
        if (!TlsUtils.isValidUint8(nameType)) {
            throw new IllegalArgumentException("'nameType' should be between 0 and 255");
        }
        if (encoded == null) {
            throw new NullPointerException("'encoded' cannot be null");
        }
        this.nameType = nameType;
        this.encoded = TlsUtils.clone(encoded);
    }

    public final int getType() {
        return this.nameType;
    }

    public final byte[] getEncoded() {
        return TlsUtils.clone(this.encoded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BCSNIServerName)) {
            return false;
        }
        BCSNIServerName other = (BCSNIServerName)obj;
        return this.nameType == other.nameType && Arrays.areEqual(this.encoded, other.encoded);
    }

    public int hashCode() {
        return this.nameType ^ Arrays.hashCode(this.encoded);
    }

    public String toString() {
        return "{type=" + NameType.getText((short)this.nameType) + ", value=" + Hex.toHexString(this.encoded) + "}";
    }
}

