/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jsse.provider;

import com.apusic.org.bouncycastle.jsse.provider.PropertyUtils;
import com.apusic.org.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import com.apusic.org.bouncycastle.tls.crypto.DHGroup;

class ProvDHGroupVerifier
extends DefaultTlsDHGroupVerifier {
    private static final int provMinimumPrimeBits = PropertyUtils.getIntegerSystemProperty("com.apusic.org.bouncycastle.jsse.client.dh.minimumPrimeBits", 2048, 1024, 16384);
    private static final boolean provUnrestrictedGroups = PropertyUtils.getBooleanSystemProperty("com.apusic.org.bouncycastle.jsse.client.dh.unrestrictedGroups", false);

    ProvDHGroupVerifier() {
        super(provMinimumPrimeBits);
    }

    protected boolean checkGroup(DHGroup dhGroup) {
        return provUnrestrictedGroups || super.checkGroup(dhGroup);
    }
}

