/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.math.ec.custom.djb;

import com.apusic.org.bouncycastle.math.ec.AbstractECLookupTable;
import com.apusic.org.bouncycastle.math.ec.ECConstants;
import com.apusic.org.bouncycastle.math.ec.ECCurve;
import com.apusic.org.bouncycastle.math.ec.ECFieldElement;
import com.apusic.org.bouncycastle.math.ec.ECLookupTable;
import com.apusic.org.bouncycastle.math.ec.ECPoint;
import com.apusic.org.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.apusic.org.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import com.apusic.org.bouncycastle.math.ec.custom.djb.Curve25519Point;
import com.apusic.org.bouncycastle.math.raw.Nat256;
import com.apusic.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q = Curve25519FieldElement.Q;
    private static final BigInteger C_a = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
    private static final BigInteger C_b = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
    private static final int CURVE25519_DEFAULT_COORDS = 4;
    private static final ECFieldElement[] CURVE25519_AFFINE_ZS = new ECFieldElement[]{new Curve25519FieldElement(ECConstants.ONE), new Curve25519FieldElement(C_a)};
    protected Curve25519Point infinity = new Curve25519Point(this, null, null);

    public Curve25519() {
        super(q);
        this.a = this.fromBigInteger(C_a);
        this.b = this.fromBigInteger(C_b);
        this.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        this.cofactor = BigInteger.valueOf(8L);
        this.coord = 4;
    }

    protected ECCurve cloneCurve() {
        return new Curve25519();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new Curve25519FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new Curve25519Point(this, x, y);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new Curve25519Point(this, x, y, zs);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_INTS = 8;
        final int[] table = new int[len * 8 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat256.copy(((Curve25519FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat256.copy(((Curve25519FieldElement)p.getRawYCoord()).x, 0, table, pos += 8);
            pos += 8;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                int[] x = Nat256.create();
                int[] y = Nat256.create();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    int MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 8; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 8 + j] & MASK;
                    }
                    pos += 16;
                }
                return this.createPoint(x, y);
            }

            public ECPoint lookupVar(int index) {
                int[] x = Nat256.create();
                int[] y = Nat256.create();
                int pos = index * 8 * 2;
                for (int j = 0; j < 8; ++j) {
                    x[j] = table[pos + j];
                    y[j] = table[pos + 8 + j];
                }
                return this.createPoint(x, y);
            }

            private ECPoint createPoint(int[] x, int[] y) {
                return Curve25519.this.createRawPoint(new Curve25519FieldElement(x), new Curve25519FieldElement(y), CURVE25519_AFFINE_ZS);
            }
        };
    }

    public ECFieldElement randomFieldElement(SecureRandom r) {
        int[] x = Nat256.create();
        Curve25519Field.random(r, x);
        return new Curve25519FieldElement(x);
    }

    public ECFieldElement randomFieldElementMult(SecureRandom r) {
        int[] x = Nat256.create();
        Curve25519Field.randomMult(r, x);
        return new Curve25519FieldElement(x);
    }
}

