/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.math.ec.endo;

import com.apusic.org.bouncycastle.math.ec.ECCurve;
import com.apusic.org.bouncycastle.math.ec.ECPointMap;
import com.apusic.org.bouncycastle.math.ec.ScaleYNegateXPointMap;
import com.apusic.org.bouncycastle.math.ec.endo.EndoUtil;
import com.apusic.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.apusic.org.bouncycastle.math.ec.endo.GLVTypeAParameters;
import java.math.BigInteger;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve curve, GLVTypeAParameters parameters) {
        this.parameters = parameters;
        this.pointMap = new ScaleYNegateXPointMap(curve.fromBigInteger(parameters.getI()));
    }

    public BigInteger[] decomposeScalar(BigInteger k) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), k);
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }
}

